/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.io;

import org.audit4j.core.dto.AnnotationAuditEvent;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.dto.EventBatch;
import org.audit4j.core.io.AuditOutputStream;
import reactor.core.Environment;
import reactor.core.composable.Deferred;
import reactor.core.composable.Stream;
import reactor.core.composable.spec.DeferredStreamSpec;
import reactor.core.composable.spec.Streams;
import reactor.function.Consumer;
import reactor.function.support.Boundary;

public class AsyncAuditOutputStream
implements AuditOutputStream<AuditEvent> {
    AuditOutputStream<AuditEvent> outputStream;
    AuditOutputStream<AnnotationAuditEvent> annotationStream;
    Deferred<AuditEvent, Stream<AuditEvent>> deferred = null;
    Deferred<EventBatch, Stream<EventBatch>> batchDeferred = null;
    Deferred<AnnotationAuditEvent, Stream<AnnotationAuditEvent>> annotationDeferred = null;
    static Environment ENV;
    Boundary b = null;
    Boundary batchBoundry = null;

    public AsyncAuditOutputStream(final AuditOutputStream<AuditEvent> outputStream, AuditOutputStream<AnnotationAuditEvent> annotationStream) {
        this.outputStream = outputStream;
        this.annotationStream = annotationStream;
        ENV = new Environment();
        this.b = new Boundary();
        this.deferred = (Deferred)((DeferredStreamSpec)((DeferredStreamSpec)Streams.defer().env(ENV)).dispatcher("ringBuffer")).get();
        Stream stream = (Stream)this.deferred.compose();
        stream.consume(this.b.bind((Consumer)new Consumer<AuditEvent>(){

            public void accept(AuditEvent event) {
                outputStream.write(event);
            }
        }));
        this.batchBoundry = new Boundary();
        this.batchDeferred = (Deferred)((DeferredStreamSpec)((DeferredStreamSpec)Streams.defer().env(ENV)).dispatcher("ringBuffer")).get();
        Stream batchStream = (Stream)this.batchDeferred.compose();
        batchStream.consume(this.batchBoundry.bind((Consumer)new Consumer<EventBatch>(){

            public void accept(EventBatch batch) {
                outputStream.writeBatch(batch);
            }
        }));
    }

    public AsyncAuditOutputStream write(AuditEvent event) {
        if (event instanceof AnnotationAuditEvent) {
            this.annotationStream.write((AnnotationAuditEvent)event);
        } else {
            this.deferred.accept((Object)event);
            this.b.await();
        }
        return this;
    }

    @Override
    public AuditOutputStream<AuditEvent> writeBatch(EventBatch batch) {
        this.batchDeferred.accept((Object)batch);
        this.batchBoundry.await();
        return this;
    }

    @Override
    public void close() {
        ENV.shutdown();
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    @Override
    public Object clone() {
        return null;
    }
}

