/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.io;

import org.audit4j.core.ConcurrentConfigurationContext;
import org.audit4j.core.LifeCycleContext;
import org.audit4j.core.RunStatus;
import org.audit4j.core.ValidationManager;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.dto.Event;
import org.audit4j.core.dto.EventBatch;
import org.audit4j.core.exception.ValidationException;
import org.audit4j.core.filter.AuditEventFilter;
import org.audit4j.core.io.AuditOutputStream;

public class AuditEventOutputStream
implements AuditOutputStream<AuditEvent> {
    AuditOutputStream<AuditEvent> outputStream;
    private ConcurrentConfigurationContext configContext;

    public AuditEventOutputStream(AuditOutputStream<AuditEvent> outputStream, ConcurrentConfigurationContext configContext) {
        this.outputStream = outputStream;
        this.configContext = configContext;
    }

    public AuditEventOutputStream write(AuditEvent event) {
        if (LifeCycleContext.getInstance().getStatus().equals((Object)RunStatus.RUNNING)) {
            try {
                ValidationManager.validateEvent(event);
                if (this.configContext.getFilters().isEmpty() || this.filterAccepts(event)) {
                    this.outputStream.write(event);
                }
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public AuditOutputStream<AuditEvent> writeBatch(EventBatch<AuditEvent> batch) {
        if (LifeCycleContext.getInstance().getStatus().equals((Object)RunStatus.RUNNING)) {
            if (!this.configContext.getFilters().isEmpty()) {
                for (AuditEvent event : batch) {
                    if (this.filterAccepts(event)) continue;
                    batch.removeEvent(event);
                }
            }
            this.outputStream.writeBatch(batch);
        }
        return this;
    }

    private boolean filterAccepts(Event event) {
        for (AuditEventFilter filter : this.configContext.getFilters()) {
            if (filter.accepts(event)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    @Override
    public Object clone() {
        return null;
    }
}

