/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.io;

import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.dto.EventBatch;
import org.audit4j.core.io.AuditOutputStream;

public class BatchProcessStream
implements AuditOutputStream<AuditEvent> {
    AuditOutputStream<AuditEvent> outputStream;
    private int batchSize;
    private EventBatch batch = new EventBatch();

    public BatchProcessStream(AuditOutputStream<AuditEvent> outputStream, int batchSize) {
        this.outputStream = outputStream;
        this.batchSize = batchSize;
    }

    @Override
    public AuditOutputStream<AuditEvent> write(AuditEvent event) {
        if (this.batch.size() < (long)(this.batchSize - 1)) {
            this.batch.addEvent(event);
        } else {
            this.batch.addEvent(event);
            this.writeBatch(this.batch);
            this.batch = new EventBatch();
        }
        return this;
    }

    @Override
    public AuditOutputStream<AuditEvent> writeBatch(EventBatch<AuditEvent> batch) {
        this.outputStream.writeBatch(batch);
        return this;
    }

    @Override
    public void close() {
        if (!this.batch.isEmpty()) {
            this.writeBatch(this.batch);
        }
    }

    @Override
    public Object clone() {
        return null;
    }
}

