/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.layout;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.Renderer;
import java.util.Date;
import java.util.HashMap;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.layout.Layout;
import org.audit4j.core.util.JMTEDateRendrer;

public class CustomizableLayout
implements Layout {
    private static final long serialVersionUID = 8488465359841862664L;
    private static final String DEFAULT_TEMPLATE = "${eventDate}|${uuid}|${actor}|${action}|${origin} => ${foreach fields field}${field.name} ${field.type}:${field.value}, ${end}";
    private Engine engine;
    private String dateFormat = "MM/dd/yyyy HH:mm:ss";
    private String template = "${eventDate}|${uuid}|${actor}|${action}|${origin} => ${foreach fields field}${field.name} ${field.type}:${field.value}, ${end}";

    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void init() throws InitializationException {
        this.engine = Engine.createCachingEngine();
        JMTEDateRendrer dateRendrer = new JMTEDateRendrer();
        dateRendrer.setDateFormat(this.dateFormat);
        this.engine.registerRenderer(Date.class, (Renderer)dateRendrer);
    }

    @Override
    public void stop() {
    }

    @Override
    public String format(AuditEvent event) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("eventDate", event.getTimestamp());
        model.put("uuid", event.getUuid());
        model.put("action", event.getAction());
        model.put("origin", event.getOrigin());
        model.put("actor", event.getActor());
        model.put("fields", event.getFields());
        return this.engine.transform(this.template, model);
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }
}

