/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.layout;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.exception.Audit4jRuntimeException;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.layout.SimpleLayout;
import org.audit4j.core.util.EncryptionUtil;

public class SecureLayout
extends SimpleLayout {
    private static final long serialVersionUID = -5678939488854601303L;
    private String key;
    private String salt;
    private EncryptionUtil util;

    @Override
    public String format(AuditEvent event) {
        String formatText = super.format(event);
        try {
            return this.util.encrypt(formatText);
        }
        catch (InvalidKeyException e) {
            throw new Audit4jRuntimeException("", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new Audit4jRuntimeException("", e);
        }
        catch (BadPaddingException e) {
            throw new Audit4jRuntimeException("", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Audit4jRuntimeException("", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Audit4jRuntimeException("", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Audit4jRuntimeException("", e);
        }
        catch (NoSuchPaddingException e) {
            throw new Audit4jRuntimeException("", e);
        }
    }

    @Override
    public void init() throws InitializationException {
        if (this.key == null) {
            this.key = "Aud1T4jSecureKey";
        }
        if (this.salt == null) {
            this.salt = "232332324";
        }
        try {
            this.util = EncryptionUtil.getInstance(this.key, this.salt);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InitializationException("Could not Initialize the layout: " + SecureLayout.class.getName(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new InitializationException("Could not Initialize the layout: " + SecureLayout.class.getName(), e);
        }
        catch (InvalidKeySpecException e) {
            throw new InitializationException("Could not Initialize the layout: " + SecureLayout.class.getName(), e);
        }
        super.init();
    }

    @Override
    public void stop() {
        super.stop();
        this.util = null;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }
}

