/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.layout;

import java.util.Date;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.dto.Field;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.layout.Layout;
import org.audit4j.core.util.ConcurrentDateFormatAccess;

public class SimpleLayout
implements Layout {
    private static final long serialVersionUID = 5057576669171592167L;
    private String dateFormat = "MM/dd/yyyy HH:mm:ss";

    @Override
    public String format(AuditEvent event) {
        StringBuilder buff = new StringBuilder();
        if (null != event.getTimestamp()) {
            buff.append(new ConcurrentDateFormatAccess(this.dateFormat).convertDateToString(event.getTimestamp()));
        } else {
            buff.append(new ConcurrentDateFormatAccess(this.dateFormat).convertDateToString(new Date()));
        }
        buff.append('|');
        if (null != event.getUuid()) {
            buff.append(event.getUuid().toString());
            buff.append('|');
        }
        buff.append(event.getActor());
        buff.append('|');
        buff.append(event.getOrigin());
        buff.append('|');
        if (event.getAction() != null) {
            buff.append(event.getAction()).append("==>");
        }
        if (event.getFields() != null && !event.getFields().isEmpty()) {
            for (Field actionItem : event.getFields()) {
                buff.append(actionItem.getName()).append(' ').append(actionItem.getType()).append(':').append(actionItem.getValue()).append(',');
            }
        }
        return buff.toString();
    }

    @Override
    public void init() throws InitializationException {
    }

    @Override
    public void stop() {
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }
}

