/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.schedule;

import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.enterprise.concurrent.ManagedExecutors;
import org.audit4j.core.schedule.AsyncTaskExecutor;
import org.audit4j.core.schedule.SchedulingAwareRunnable;
import org.audit4j.core.schedule.SchedulingTaskExecutor;
import org.audit4j.core.schedule.TaskExecutorAdapter;

public class ConcurrentTaskExecutor
implements AsyncTaskExecutor,
SchedulingTaskExecutor {
    private static Class<?> managedExecutorServiceClass;
    private Executor concurrentExecutor;
    private TaskExecutorAdapter adaptedExecutor;

    public ConcurrentTaskExecutor() {
        this.setConcurrentExecutor(null);
    }

    public ConcurrentTaskExecutor(Executor concurrentExecutor) {
        this.setConcurrentExecutor(concurrentExecutor);
    }

    public final void setConcurrentExecutor(Executor concurrentExecutor) {
        if (concurrentExecutor != null) {
            this.concurrentExecutor = concurrentExecutor;
            this.adaptedExecutor = managedExecutorServiceClass != null && managedExecutorServiceClass.isInstance(concurrentExecutor) ? new ManagedTaskExecutorAdapter(concurrentExecutor) : new TaskExecutorAdapter(concurrentExecutor);
        } else {
            this.concurrentExecutor = Executors.newSingleThreadExecutor();
            this.adaptedExecutor = new TaskExecutorAdapter(this.concurrentExecutor);
        }
    }

    public final Executor getConcurrentExecutor() {
        return this.concurrentExecutor;
    }

    @Override
    public void execute(Runnable task) {
        this.adaptedExecutor.execute(task);
    }

    @Override
    public void execute(Runnable task, long startTimeout) {
        this.adaptedExecutor.execute(task, startTimeout);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.adaptedExecutor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.adaptedExecutor.submit(task);
    }

    @Override
    public boolean prefersShortLivedTasks() {
        return true;
    }

    static {
        try {
            managedExecutorServiceClass = Class.forName("javax.enterprise.concurrent.ManagedExecutorService");
        }
        catch (ClassNotFoundException ex) {
            managedExecutorServiceClass = null;
        }
    }

    private static class ManagedTaskExecutorAdapter
    extends TaskExecutorAdapter {
        public ManagedTaskExecutorAdapter(Executor concurrentExecutor) {
            super(concurrentExecutor);
        }

        @Override
        public void execute(Runnable task) {
            super.execute(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public Future<?> submit(Runnable task) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }
    }

    protected static class ManagedTaskBuilder {
        protected ManagedTaskBuilder() {
        }

        public static Runnable buildManagedTask(Runnable task, String identityName) {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            if (task instanceof SchedulingAwareRunnable) {
                properties.put("javax.enterprise.concurrent.LONGRUNNING_HINT", Boolean.toString(((SchedulingAwareRunnable)task).isLongLived()));
            }
            properties.put("javax.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask((Runnable)task, properties, null);
        }

        public static <T> Callable<T> buildManagedTask(Callable<T> task, String identityName) {
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("javax.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask(task, properties, null);
        }
    }
}

