/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.schedule;

import java.lang.reflect.UndeclaredThrowableException;
import org.audit4j.core.schedule.util.ErrorHandler;

public class DelegatingErrorHandlingRunnable
implements Runnable {
    private final Runnable delegate;
    private final ErrorHandler errorHandler;

    public DelegatingErrorHandlingRunnable(Runnable delegate, ErrorHandler errorHandler) {
        this.delegate = delegate;
        this.errorHandler = errorHandler;
    }

    @Override
    public void run() {
        try {
            this.delegate.run();
        }
        catch (UndeclaredThrowableException ex) {
            this.errorHandler.handleError(ex.getUndeclaredThrowable());
        }
        catch (Throwable ex) {
            this.errorHandler.handleError(ex);
        }
    }

    public String toString() {
        return "DelegatingErrorHandlingRunnable for " + this.delegate;
    }
}

