/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.schedule;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.audit4j.core.schedule.Trigger;
import org.audit4j.core.schedule.TriggerContext;

public class PeriodicTrigger
implements Trigger {
    private final long period;
    private final TimeUnit timeUnit;
    private volatile long initialDelay = 0L;
    private volatile boolean fixedRate = false;

    public PeriodicTrigger(long period) {
        this(period, null);
    }

    public PeriodicTrigger(long period, TimeUnit timeUnit) {
        this.timeUnit = timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS;
        this.period = this.timeUnit.toMillis(period);
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = this.timeUnit.toMillis(initialDelay);
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    @Override
    public Date nextExecutionTime(TriggerContext triggerContext) {
        if (triggerContext.lastScheduledExecutionTime() == null) {
            return new Date(System.currentTimeMillis() + this.initialDelay);
        }
        if (this.fixedRate) {
            return new Date(triggerContext.lastScheduledExecutionTime().getTime() + this.period);
        }
        return new Date(triggerContext.lastCompletionTime().getTime() + this.period);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PeriodicTrigger)) {
            return false;
        }
        PeriodicTrigger other = (PeriodicTrigger)obj;
        return this.fixedRate == other.fixedRate && this.initialDelay == other.initialDelay && this.period == other.period;
    }

    public int hashCode() {
        return (this.fixedRate ? 17 : 29) + (int)(37L * this.period) + (int)(41L * this.initialDelay);
    }
}

