/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.schedule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.audit4j.core.schedule.ConcurrentTaskScheduler;
import org.audit4j.core.schedule.CustomizableThreadFactory;
import org.audit4j.core.schedule.TaskScheduler;
import org.audit4j.core.schedule.ThreadPoolTaskScheduler;
import org.audit4j.core.schedule.Trigger;
import org.audit4j.core.schedule.TriggerTask;

public class Schedulers {
    private static int noOfSchedullers = 0;
    private static int noOfRunningSchedullers = 0;
    private TaskScheduler currentScheduler;
    private static Schedulers instance;
    private final Map<String, ScheduledFuture<?>> runningSchedullers = new ConcurrentHashMap();

    public static Schedulers newDefault() {
        Schedulers.createSingleton();
        Schedulers.increaseNoOfSchedullers();
        instance.setCurrentScheduler(new ConcurrentTaskScheduler());
        return instance;
    }

    public static Schedulers newThreadPoolScheduler(int poolSize) {
        Schedulers.createSingleton();
        Schedulers.increaseNoOfSchedullers();
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        CustomizableThreadFactory factory = new CustomizableThreadFactory();
        scheduler.initializeExecutor(factory, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                System.out.println("asdsa");
            }
        });
        scheduler.setPoolSize(poolSize);
        instance.setCurrentScheduler(scheduler);
        return instance;
    }

    public static Schedulers stop(String schedulerId) {
        Schedulers.createSingleton();
        ScheduledFuture<?> future = Schedulers.instance.runningSchedullers.get(schedulerId);
        if (future == null) {
            throw new IllegalStateException("No schedulers match with given id.");
        }
        future.cancel(true);
        Schedulers.decreaseNoOfSchedullers();
        Schedulers.decreaseNoOfRunningSchedullers();
        return instance;
    }

    public static Schedulers stopAll() {
        Schedulers.createSingleton();
        if (Schedulers.instance.runningSchedullers.isEmpty()) {
            throw new IllegalStateException("No schedulers available.");
        }
        for (Map.Entry<String, ScheduledFuture<?>> entry : Schedulers.instance.runningSchedullers.entrySet()) {
            ScheduledFuture<?> future = entry.getValue();
            future.cancel(true);
            Schedulers.decreaseNoOfSchedullers();
            Schedulers.decreaseNoOfRunningSchedullers();
        }
        return instance;
    }

    public String schedule(TriggerTask task) {
        if (this.getCurrentScheduler() == null) {
            throw new IllegalStateException("New scheduler should be crea");
        }
        ScheduledFuture<?> future = this.getCurrentScheduler().schedule(task.getRunnable(), task.getTrigger());
        String id = Schedulers.getUUID();
        this.runningSchedullers.put(id, future);
        Schedulers.increaseNoOfRunningSchedullers();
        this.setCurrentScheduler(null);
        return id;
    }

    public String schedule(Trigger trigger, Runnable task) {
        ScheduledFuture<?> future = this.getCurrentScheduler().schedule(task, trigger);
        String id = Schedulers.getUUID();
        this.runningSchedullers.put(id, future);
        Schedulers.increaseNoOfRunningSchedullers();
        this.setCurrentScheduler(null);
        return id;
    }

    public static TaskRegistrar taskRegistry() {
        return TaskRegistrar.getInstance();
    }

    private static synchronized void increaseNoOfSchedullers() {
        ++noOfSchedullers;
    }

    private static synchronized void increaseNoOfRunningSchedullers() {
        ++noOfRunningSchedullers;
    }

    private static synchronized void decreaseNoOfSchedullers() {
        --noOfSchedullers;
    }

    private static synchronized void decreaseNoOfRunningSchedullers() {
        --noOfRunningSchedullers;
    }

    private static synchronized String getUUID() {
        return String.valueOf(UUID.randomUUID().getLeastSignificantBits());
    }

    public static int getCreatedSchedulerCount() {
        return noOfSchedullers;
    }

    public static int getRunningSchedulerCount() {
        return noOfRunningSchedullers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schedulers createSingleton() {
        Class<Schedulers> clazz = Schedulers.class;
        synchronized (Schedulers.class) {
            if (instance == null) {
                instance = new Schedulers();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TaskScheduler getCurrentScheduler() {
        return this.currentScheduler;
    }

    public void setCurrentScheduler(TaskScheduler currentScheduler) {
        this.currentScheduler = currentScheduler;
    }

    public static class TaskRegistrar {
        List<TriggerTask> triggerTasks = new CopyOnWriteArrayList<TriggerTask>();
        List<String> runningIds = new ArrayList<String>();
        private static TaskRegistrar regInstance;

        public TaskRegistrar registor(TriggerTask task) {
            this.triggerTasks.add(task);
            return regInstance;
        }

        public TaskRegistrar registor(Trigger trigger, Runnable task) {
            this.triggerTasks.add(new TriggerTask(task, trigger));
            return regInstance;
        }

        public List<String> scheduleAll() {
            for (TriggerTask task : this.triggerTasks) {
                String id = Schedulers.newDefault().schedule(task);
                this.runningIds.add(id);
            }
            this.triggerTasks.clear();
            return this.runningIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TaskRegistrar getInstance() {
            Class<TaskRegistrar> clazz = TaskRegistrar.class;
            synchronized (TaskRegistrar.class) {
                if (regInstance == null) {
                    regInstance = new TaskRegistrar();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return regInstance;
            }
        }
    }

    public static enum ExecutorType {
        DEFAULT,
        THREADED;

    }
}

