/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.schedule;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import org.audit4j.core.schedule.AsyncTaskExecutor;
import org.audit4j.core.schedule.TaskRejectedException;

public class TaskExecutorAdapter
implements AsyncTaskExecutor {
    private final Executor concurrentExecutor;

    public TaskExecutorAdapter(Executor concurrentExecutor) {
        this.concurrentExecutor = concurrentExecutor;
    }

    @Override
    public void execute(Runnable task) {
        try {
            this.concurrentExecutor.execute(task);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public void execute(Runnable task, long startTimeout) {
        this.execute(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        try {
            if (this.concurrentExecutor instanceof ExecutorService) {
                return ((ExecutorService)this.concurrentExecutor).submit(task);
            }
            FutureTask<Object> future = new FutureTask<Object>(task, null);
            this.concurrentExecutor.execute(future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try {
            if (this.concurrentExecutor instanceof ExecutorService) {
                return ((ExecutorService)this.concurrentExecutor).submit(task);
            }
            FutureTask<T> future = new FutureTask<T>(task);
            this.concurrentExecutor.execute(future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex);
        }
    }
}

