/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.schedule;

import org.audit4j.core.schedule.DelegatingErrorHandlingRunnable;
import org.audit4j.core.schedule.util.ErrorHandler;

public abstract class TaskUtils {
    public static final ErrorHandler LOG_AND_SUPPRESS_ERROR_HANDLER = new LoggingErrorHandler();
    public static final ErrorHandler LOG_AND_PROPAGATE_ERROR_HANDLER = new PropagatingErrorHandler();

    private TaskUtils() {
    }

    public static DelegatingErrorHandlingRunnable decorateTaskWithErrorHandler(Runnable task, ErrorHandler errorHandler, boolean isRepeatingTask) {
        if (task instanceof DelegatingErrorHandlingRunnable) {
            return (DelegatingErrorHandlingRunnable)task;
        }
        ErrorHandler eh = errorHandler != null ? errorHandler : TaskUtils.getDefaultErrorHandler(isRepeatingTask);
        return new DelegatingErrorHandlingRunnable(task, eh);
    }

    public static ErrorHandler getDefaultErrorHandler(boolean isRepeatingTask) {
        return isRepeatingTask ? LOG_AND_SUPPRESS_ERROR_HANDLER : LOG_AND_PROPAGATE_ERROR_HANDLER;
    }

    private static class LoggingErrorHandler
    implements ErrorHandler {
        private LoggingErrorHandler() {
        }

        @Override
        public void handleError(Throwable t) {
        }
    }

    private static class PropagatingErrorHandler
    extends LoggingErrorHandler {
        private PropagatingErrorHandler() {
        }

        @Override
        public void handleError(Throwable t) {
            super.handleError(t);
        }
    }
}

