/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.schedule;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.audit4j.core.schedule.AsyncTaskExecutor;
import org.audit4j.core.schedule.ReschedulingRunnable;
import org.audit4j.core.schedule.SchedulingTaskExecutor;
import org.audit4j.core.schedule.TaskRejectedException;
import org.audit4j.core.schedule.TaskScheduler;
import org.audit4j.core.schedule.TaskUtils;
import org.audit4j.core.schedule.Trigger;
import org.audit4j.core.schedule.util.ClassUtils;
import org.audit4j.core.schedule.util.ErrorHandler;

public class ThreadPoolTaskScheduler
implements AsyncTaskExecutor,
SchedulingTaskExecutor,
TaskScheduler {
    private static final boolean setRemoveOnCancelPolicyAvailable = ClassUtils.hasMethod(ScheduledThreadPoolExecutor.class, "setRemoveOnCancelPolicy", Boolean.TYPE);
    private volatile int poolSize = 1;
    private volatile boolean removeOnCancelPolicy = false;
    private volatile ScheduledExecutorService scheduledExecutor;
    private volatile ErrorHandler errorHandler;

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        if (this.scheduledExecutor instanceof ScheduledThreadPoolExecutor) {
            ((ScheduledThreadPoolExecutor)this.scheduledExecutor).setCorePoolSize(poolSize);
        }
    }

    public void setRemoveOnCancelPolicy(boolean removeOnCancelPolicy) {
        this.removeOnCancelPolicy = removeOnCancelPolicy;
        if (setRemoveOnCancelPolicyAvailable && this.scheduledExecutor instanceof ScheduledThreadPoolExecutor) {
            ((ScheduledThreadPoolExecutor)this.scheduledExecutor).setRemoveOnCancelPolicy(removeOnCancelPolicy);
        } else if (!removeOnCancelPolicy || this.scheduledExecutor != null) {
            // empty if block
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        this.scheduledExecutor = this.createExecutor(this.poolSize, threadFactory, rejectedExecutionHandler);
        if (this.removeOnCancelPolicy && setRemoveOnCancelPolicyAvailable && this.scheduledExecutor instanceof ScheduledThreadPoolExecutor) {
            ((ScheduledThreadPoolExecutor)this.scheduledExecutor).setRemoveOnCancelPolicy(true);
        }
        return this.scheduledExecutor;
    }

    protected ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return new ScheduledThreadPoolExecutor(poolSize, threadFactory, rejectedExecutionHandler);
    }

    public ScheduledExecutorService getScheduledExecutor() throws IllegalStateException {
        return this.scheduledExecutor;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() throws IllegalStateException {
        return (ScheduledThreadPoolExecutor)this.scheduledExecutor;
    }

    public int getPoolSize() {
        if (this.scheduledExecutor == null) {
            return this.poolSize;
        }
        return this.getScheduledThreadPoolExecutor().getPoolSize();
    }

    public boolean isRemoveOnCancelPolicy() {
        if (!setRemoveOnCancelPolicyAvailable) {
            return false;
        }
        if (this.scheduledExecutor == null) {
            return this.removeOnCancelPolicy;
        }
        return this.getScheduledThreadPoolExecutor().getRemoveOnCancelPolicy();
    }

    public int getActiveCount() {
        if (this.scheduledExecutor == null) {
            return 0;
        }
        return this.getScheduledThreadPoolExecutor().getActiveCount();
    }

    @Override
    public void execute(Runnable task) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            executor.execute(this.errorHandlingTask(task, false));
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public void execute(Runnable task, long startTimeout) {
        this.execute(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.submit(this.errorHandlingTask(task, false));
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            Callable<T> taskToUse = task;
            if (this.errorHandler != null) {
                taskToUse = new DelegatingErrorHandlingCallable<T>(task, this.errorHandler);
            }
            return executor.submit(taskToUse);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public boolean prefersShortLivedTasks() {
        return true;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            ErrorHandler errorHandlerLocal = this.errorHandler != null ? this.errorHandler : TaskUtils.getDefaultErrorHandler(true);
            return new ReschedulingRunnable(task, trigger, executor, errorHandlerLocal).schedule();
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        long initialDelay = startTime.getTime() - System.currentTimeMillis();
        try {
            return executor.schedule(this.errorHandlingTask(task, false), initialDelay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        long initialDelay = startTime.getTime() - System.currentTimeMillis();
        try {
            return executor.scheduleAtFixedRate(this.errorHandlingTask(task, true), initialDelay, period, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.scheduleAtFixedRate(this.errorHandlingTask(task, true), 0L, period, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        long initialDelay = startTime.getTime() - System.currentTimeMillis();
        try {
            return executor.scheduleWithFixedDelay(this.errorHandlingTask(task, true), initialDelay, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.scheduleWithFixedDelay(this.errorHandlingTask(task, true), 0L, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, ex);
        }
    }

    private Runnable errorHandlingTask(Runnable task, boolean isRepeatingTask) {
        return TaskUtils.decorateTaskWithErrorHandler(task, this.errorHandler, isRepeatingTask);
    }

    private static class DelegatingErrorHandlingCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;
        private final ErrorHandler errorHandler;

        public DelegatingErrorHandlingCallable(Callable<V> delegate, ErrorHandler errorHandler) {
            this.delegate = delegate;
            this.errorHandler = errorHandler;
        }

        @Override
        public V call() throws Exception {
            try {
                return this.delegate.call();
            }
            catch (Throwable t) {
                this.errorHandler.handleError(t);
                return null;
            }
        }
    }
}

