/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.util;

import java.io.File;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public final class AuditUtil {
    private AuditUtil() {
    }

    public static Map<String, String> transformMap(Map<String, Object> paramMap) {
        LinkedHashMap<String, String> paramStrMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            paramStrMap.put(entry.getKey(), entry.getValue().toString());
        }
        return paramStrMap;
    }

    protected Long getUUID() {
        return UUID.randomUUID().getMostSignificantBits();
    }

    public static String dateToString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.US);
        return dateFormat.format(date);
    }

    public static Date stringTodate(String dateString, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.US);
        return dateFormat.parse(dateString);
    }

    public static String timeStampToString(Timestamp timestamp, String format) {
        return AuditUtil.dateToString(new Date(timestamp.getTime()), format);
    }

    public static boolean isFileExists(String filePathString) {
        File file = new File(filePathString);
        return file.exists() && !file.isDirectory();
    }
}

