/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.util;

public class Base64Coder {
    public static final String LINE_SEPARATOR = "line.separator";
    private static final String LINE_SEPERATOR;
    public static final int CONSTANT_3 = 3;
    public static final int CONSTANT_4 = 4;
    public static final int CONSTANT_6 = 6;
    public static final int CONSTANT_64 = 64;
    public static final int CONSTANT_76 = 76;
    public static final int CONSTANT_127 = 127;
    public static final int CONSTANT_128 = 128;
    public static final int CONSTANT_0XFF = 255;
    public static final int CONSTANT_0XF = 15;
    public static final int CONSTANT_0X3F = 63;
    private static char[] map1;
    private static byte[] map2;

    private Base64Coder() {
    }

    public static String encodeString(String text) {
        return new String(Base64Coder.encode(text.getBytes()));
    }

    public static String encodeLines(byte[] input) {
        return Base64Coder.encodeLines(input, 0, input.length, 76, LINE_SEPERATOR);
    }

    public static String encodeLines(byte[] input, int iOff, int iLen, int lineLen, String lineSeparator) {
        int length;
        int blockLen = lineLen * 3 / 4;
        if (blockLen <= 0) {
            throw new IllegalArgumentException();
        }
        int lines = (iLen + blockLen - 1) / blockLen;
        int bufLen = (iLen + 2) / 3 * 4 + lines * lineSeparator.length();
        StringBuilder buf = new StringBuilder(bufLen);
        for (int ipValue = 0; ipValue < iLen; ipValue += length) {
            length = Math.min(iLen - ipValue, blockLen);
            buf.append(Base64Coder.encode(input, iOff + ipValue, length));
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    public static char[] encode(byte[] input) {
        return Base64Coder.encode(input, 0, input.length);
    }

    public static char[] encode(byte[] input, int iLen) {
        return Base64Coder.encode(input, 0, iLen);
    }

    public static char[] encode(byte[] input, int iOff, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ipValue = iOff;
        int iEnd = iOff + iLen;
        int opValue = 0;
        while (ipValue < iEnd) {
            int i0Value = input[ipValue++] & 0xFF;
            int i1Value = ipValue < iEnd ? input[ipValue++] & 0xFF : 0;
            int i2Value = ipValue < iEnd ? input[ipValue++] & 0xFF : 0;
            int o0Value = i0Value >>> 2;
            int o1Value = (i0Value & 3) << 4 | i1Value >>> 4;
            int o2Value = (i1Value & 0xF) << 2 | i2Value >>> 6;
            int o3Value = i2Value & 0x3F;
            out[opValue++] = map1[o0Value];
            out[opValue++] = map1[o1Value];
            out[opValue] = opValue < oDataLen ? map1[o2Value] : 61;
            int n = ++opValue < oDataLen ? map1[o3Value] : 61;
            out[opValue] = n;
            ++opValue;
        }
        return out;
    }

    public static String decodeString(String text) {
        return new String(Base64Coder.decode(text));
    }

    public static byte[] decodeLines(String text) {
        char[] buf = new char[text.length()];
        int pValue = 0;
        for (int ip = 0; ip < text.length(); ++ip) {
            char cValue = text.charAt(ip);
            if (cValue == ' ' || cValue == '\r' || cValue == '\n' || cValue == '\t') continue;
            buf[pValue++] = cValue;
        }
        return Base64Coder.decode(buf, 0, pValue);
    }

    public static byte[] decode(String text) {
        return Base64Coder.decode(text.toCharArray());
    }

    public static byte[] decode(char[] input) {
        return Base64Coder.decode(input, 0, input.length);
    }

    public static byte[] decode(char[] input, int iOff, int iLen) {
        int tiLen = iLen;
        if (tiLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (tiLen > 0 && input[iOff + tiLen - 1] == '=') {
            --tiLen;
        }
        int oLen = tiLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ipValue = iOff;
        int iEnd = iOff + tiLen;
        int opValue = 0;
        while (ipValue < iEnd) {
            int i3Value;
            char i0Value = input[ipValue++];
            char i1Value = input[ipValue++];
            int i2Value = ipValue < iEnd ? input[ipValue++] : 65;
            int n = i3Value = ipValue < iEnd ? input[ipValue++] : 65;
            if (i0Value > '\u007f' || i1Value > '\u007f' || i2Value > 127 || i3Value > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0Value = map2[i0Value];
            byte b1Value = map2[i1Value];
            byte b2Value = map2[i2Value];
            byte b3Value = map2[i3Value];
            if (b0Value < 0 || b1Value < 0 || b2Value < 0 || b3Value < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0Value = b0Value << 2 | b1Value >>> 4;
            int o1Value = (b1Value & 0xF) << 4 | b2Value >>> 2;
            int o2Value = (b2Value & 3) << 6 | b3Value;
            out[opValue++] = (byte)o0Value;
            if (opValue < oLen) {
                out[opValue++] = (byte)o1Value;
            }
            if (opValue >= oLen) continue;
            out[opValue++] = (byte)o2Value;
        }
        return out;
    }

    static {
        int i;
        int c;
        LINE_SEPERATOR = System.getProperty(LINE_SEPARATOR);
        map1 = new char[64];
        int var = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64Coder.map1[var++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64Coder.map1[var++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64Coder.map1[var++] = c;
        }
        Base64Coder.map1[var++] = 43;
        Base64Coder.map1[var++] = 47;
        map2 = new byte[128];
        for (i = 0; i < map2.length; ++i) {
            Base64Coder.map2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64Coder.map2[Base64Coder.map1[i]] = (byte)i;
        }
    }
}

