/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConcurrentDateFormatAccess {
    private final String format;
    private final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat get() {
            return (DateFormat)super.get();
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(ConcurrentDateFormatAccess.this.format);
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(DateFormat value) {
            super.set(value);
        }
    };

    public ConcurrentDateFormatAccess(String format) {
        this.format = format;
    }

    public Date convertStringToDate(String dateString) throws ParseException {
        return this.dateFormat.get().parse(dateString);
    }

    public String convertDateToString(Date date) {
        if (date == null) {
            return null;
        }
        return this.dateFormat.get().format(date);
    }
}

