/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConcurrentTimelyBufferedArrayList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8870953621895891238L;
    private final List<E> buff = new CopyOnWriteArrayList();
    private final BufferedListener<E> listener;
    ScheduleConsumer consumer;
    Timer time;

    public ConcurrentTimelyBufferedArrayList(int timeInMills, BufferedListener<E> listener) {
        this.listener = listener;
        this.time = new Timer();
        this.consumer = new ScheduleConsumer();
        this.time.schedule((TimerTask)this.consumer, 0L, (long)timeInMills);
    }

    @Override
    public E get(int index) {
        return this.buff.get(index);
    }

    @Override
    public boolean add(E e) {
        return this.buff.add(e);
    }

    @Override
    public int size() {
        return this.buff.size();
    }

    @Override
    public boolean isEmpty() {
        return this.buff.isEmpty();
    }

    public void close() {
        this.time.cancel();
        this.consumer.cancel();
    }

    @Override
    public void clear() {
        this.buff.clear();
    }

    public List<E> getBuffered() {
        ArrayList<E> temp = new ArrayList<E>(this.buff);
        this.clear();
        return temp;
    }

    public static interface BufferedListener<E> {
        public void accept(List<E> var1);
    }

    public class ScheduleConsumer
    extends TimerTask {
        @Override
        public void run() {
            if (!ConcurrentTimelyBufferedArrayList.this.isEmpty()) {
                ConcurrentTimelyBufferedArrayList.this.listener.accept(ConcurrentTimelyBufferedArrayList.this.getBuffered());
            }
        }
    }
}

