/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.audit4j.core.handler.ConsoleAuditHandler;
import org.audit4j.core.util.Base64Coder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleAuditHandler.class);
    private static final String ALGORYITHM = "AES/CBC/PKCS5Padding";
    private static EncryptionUtil instance;
    private static Key cryptKey;

    private EncryptionUtil() {
    }

    public String encrypt(String raw) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher c = this.getCipher(1);
        byte[] encryptedVal = c.doFinal(raw.getBytes("UTF-8"));
        return new String(Base64Coder.encode(encryptedVal));
    }

    public String decrypt(String encrypted) throws Exception {
        byte[] decodedValue = Base64Coder.decode(encrypted.toCharArray());
        Cipher c = this.getCipher(2);
        byte[] decValue = c.doFinal(decodedValue);
        return new String(decValue);
    }

    private Cipher getCipher(int mode) throws InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher c = Cipher.getInstance(ALGORYITHM);
        byte[] iv = "e675f725e675f725".getBytes("UTF-8");
        c.init(mode, cryptKey, new IvParameterSpec(iv));
        return c;
    }

    private static void generateKeyIfNotAvailable(String key, String salt) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeySpecException {
        if (null == cryptKey) {
            LOG.debug("Generating Key...");
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            char[] password = key.toCharArray();
            byte[] saltBytes = salt.getBytes("UTF-8");
            PBEKeySpec spec = new PBEKeySpec(password, saltBytes, 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            byte[] encoded = tmp.getEncoded();
            cryptKey = new SecretKeySpec(encoded, "AES");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncryptionUtil getInstance(String key, String salt) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeySpecException {
        if (instance != null) return instance;
        Class<EncryptionUtil> clazz = EncryptionUtil.class;
        synchronized (EncryptionUtil.class) {
            if (instance != null) return instance;
            instance = new EncryptionUtil();
            EncryptionUtil.generateKeyIfNotAvailable(key, salt);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }
}

