/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.util;

import java.io.File;
import javax.servlet.ServletContext;
import org.audit4j.core.util.AuditUtil;
import org.audit4j.core.util.JavaVersion;

public class EnvUtil {
    private EnvUtil() {
    }

    public static boolean isJDK5() {
        return JavaVersion.isJDK_N_OrHigher(5, EnvUtil.getJavaVersion());
    }

    public static boolean isJDK6OrHigher() {
        return JavaVersion.isJDK_N_OrHigher(6, EnvUtil.getJavaVersion());
    }

    public static boolean isJDK7OrHigher() {
        return JavaVersion.isJDK_N_OrHigher(7, EnvUtil.getJavaVersion());
    }

    @Deprecated
    public static String getJavaersion() {
        return EnvUtil.getJavaVersion();
    }

    public static String getJavaVersion() {
        return JavaVersion.current();
    }

    public static boolean isJaninoAvailable() {
        ClassLoader classLoader = EnvUtil.class.getClassLoader();
        try {
            Class<?> bindingClass = classLoader.loadClass("org.codehaus.janino.ScriptEvaluator");
            return bindingClass != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isServletSpec3OrHigher(ServletContext context) {
        return context.getMajorVersion() >= 3;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }

    public static boolean hasConfigFileExists(String dirPath) {
        String filePath = dirPath + File.separator + "audit4j.conf" + ".";
        return AuditUtil.isFileExists(filePath + "yml") || AuditUtil.isFileExists(filePath + "yaml") || AuditUtil.isFileExists(filePath + "xml");
    }
}

