/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Log {
    private static final String APP_INFO = "Audit4j:INFO ";
    private static final String APP_WARN = "Audit4j:WARN ";
    private static final String APP_ERROR = "Audit4j:ERROR ";
    private static PrintStream infoStream = System.out;
    private static PrintStream warnStream = System.err;
    private static PrintStream errorStream = System.err;

    private Log() {
    }

    public static void info(Object message) {
        infoStream.println(APP_INFO + message.toString());
    }

    public static void info(Object ... message) {
        StringBuilder builder = new StringBuilder(APP_INFO);
        for (Object object : message) {
            builder.append(object.toString());
        }
        infoStream.println(builder.toString());
    }

    public static void warn(Object message) {
        warnStream.println(APP_WARN + message.toString());
    }

    public static void warn(Object ... message) {
        StringBuilder builder = new StringBuilder(APP_WARN);
        for (Object object : message) {
            builder.append(object.toString());
        }
        warnStream.println(builder.toString());
    }

    public static void warn(Object message, Throwable t) {
        warnStream.println(APP_WARN + message.toString());
        warnStream.println(Log.stackTraceToString(t));
    }

    public static void error(Object message) {
        errorStream.println(APP_ERROR + message.toString());
    }

    public static void error(Object ... message) {
        StringBuilder builder = new StringBuilder(APP_ERROR);
        for (Object object : message) {
            builder.append(object.toString());
        }
        errorStream.println(builder.toString());
    }

    public static void error(Object message, Throwable t) {
        errorStream.println(APP_ERROR + message.toString());
        errorStream.println(Log.stackTraceToString(t));
    }

    private static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

