/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.audit4j.core.exception.InitializationException;

public class ReflectUtil<I> {
    public I getNewInstance(Class<I> clazz) {
        try {
            Constructor<I> ctor = clazz.getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InitializationException("Given class not found", e);
        }
    }

    public I getNewInstance(String className) {
        try {
            return (I)this.getNewInstance(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException("Given class not found", e);
        }
    }

    public List<I> getNewInstanceList(String[] clsssList) {
        ArrayList<I> instances = new ArrayList<I>();
        for (String className : clsssList) {
            I instance = new ReflectUtil<I>().getNewInstance(className);
            instances.add(instance);
        }
        return instances;
    }
}

