/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.web;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.audit4j.core.AuditManager;
import org.audit4j.core.dto.EventBuilder;

public class AuditFilter
implements Filter {
    private String userSessionAttrName = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.userSessionAttrName = filterConfig.getServletContext().getInitParameter("userSessionAttrName");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String actor = null;
        if (this.userSessionAttrName != null && !this.userSessionAttrName.equals("")) {
            HttpSession session = request.getSession(false);
            actor = (String)session.getAttribute("userSessionAttrName");
        }
        String ipAddress = request.getRemoteAddr();
        String url = request.getRequestURL().toString();
        EventBuilder builder = new EventBuilder();
        builder.addAction(url).addOrigin(ipAddress);
        if (actor == null) {
            builder.addActor(ipAddress);
        } else {
            builder.addActor(actor + "[" + ipAddress + "]");
        }
        Map params = req.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            builder.addField((String)entry.getKey(), entry.getValue());
        }
        AuditManager.getInstance().audit(builder.build());
        chain.doFilter(req, res);
    }
}

