/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.core.web;

import javax.servlet.ServletContext;
import org.audit4j.core.Configuration;
import org.audit4j.core.MetaData;
import org.audit4j.core.layout.Layout;
import org.audit4j.core.util.ReflectUtil;

class ServletContexConfigSupport {
    ServletContexConfigSupport() {
    }

    Configuration loadConfig(ServletContext servletContext) {
        String handlers = servletContext.getInitParameter("handlers");
        String layout = servletContext.getInitParameter("layout");
        String filters = servletContext.getInitParameter("filters");
        String options = servletContext.getInitParameter("options");
        String metaData = servletContext.getInitParameter("metaData");
        String properties = servletContext.getInitParameter("properties");
        Configuration config = Configuration.INSTANCE;
        if (handlers != null && !handlers.equals("")) {
            config.setHandlers(new ReflectUtil().getNewInstanceList(handlers.split(";")));
        }
        config.setLayout((Layout)new ReflectUtil().getNewInstance(layout));
        if (filters != null && !filters.equals("")) {
            config.setFilters(new ReflectUtil().getNewInstanceList(filters.split(";")));
        }
        config.setCommands(options);
        config.setMetaData((MetaData)new ReflectUtil().getNewInstance(metaData));
        if (properties != null && !properties.equals("")) {
            String[] propertiesList;
            for (String property : propertiesList = properties.split(";")) {
                String[] keyValue = property.split(":");
                config.addProperty(keyValue[0], keyValue[1]);
            }
        }
        return config;
    }

    boolean canSearchConfigFile(ServletContext servletContext) {
        String searchConfigFile = servletContext.getInitParameter("searchConfigFile");
        if (searchConfigFile == null || searchConfigFile.equals("")) {
            return false;
        }
        return "true".equals(searchConfigFile);
    }

    boolean hasHandlers(ServletContext servletContext) {
        String handlers = servletContext.getInitParameter("handlers");
        return handlers != null && !handlers.equals("");
    }
}

