/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed.commandfilter;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;

public class AndCommandMessageFilter
implements CommandMessageFilter {
    private final CommandMessageFilter first;
    private final CommandMessageFilter second;

    @ConstructorProperties(value={"first", "second"})
    public AndCommandMessageFilter(@JsonProperty(value="first") CommandMessageFilter first, @JsonProperty(value="second") CommandMessageFilter second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean matches(@Nonnull CommandMessage<?> commandMessage) {
        return this.first.matches(commandMessage) && this.second.matches(commandMessage);
    }

    @JsonGetter
    private CommandMessageFilter getFirst() {
        return this.first;
    }

    @JsonGetter
    private CommandMessageFilter getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndCommandMessageFilter that = (AndCommandMessageFilter)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return "AndCommandMessageFilter{first=" + this.first + ", second=" + this.second + '}';
    }
}

