/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class ConnectionWrapperFactory {
    private ConnectionWrapperFactory() {
    }

    public static <I> Connection wrap(Connection connection, Class<I> wrapperInterface, I wrapperHandler, ConnectionCloseHandler closeHandler) {
        return (Connection)Proxy.newProxyInstance(wrapperHandler.getClass().getClassLoader(), new Class[]{Connection.class, wrapperInterface}, (proxy, method, args) -> {
            if ("equals".equals(method.getName()) && args != null && args.length == 1) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                return connection.hashCode();
            }
            if (method.getDeclaringClass().isAssignableFrom(wrapperInterface)) {
                return ConnectionWrapperFactory.invokeMethodAndUnwrapNestedException(method, wrapperHandler, args);
            }
            if ("close".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                closeHandler.close(connection);
                return null;
            }
            if ("commit".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                closeHandler.commit(connection);
                return null;
            }
            return ConnectionWrapperFactory.invokeMethodAndUnwrapNestedException(method, connection, args);
        });
    }

    public static Connection wrap(Connection connection, ConnectionCloseHandler closeHandler) {
        return (Connection)Proxy.newProxyInstance(closeHandler.getClass().getClassLoader(), new Class[]{Connection.class}, (proxy, method, args) -> {
            if ("equals".equals(method.getName()) && args != null && args.length == 1) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                return connection.hashCode();
            }
            if ("close".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                closeHandler.close(connection);
                return null;
            }
            if ("commit".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                closeHandler.commit(connection);
                return null;
            }
            return ConnectionWrapperFactory.invokeMethodAndUnwrapNestedException(method, connection, args);
        });
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private static Object invokeMethodAndUnwrapNestedException(Method method, Object objectToInvokeMethodOn, Object[] args) throws Throwable {
        try {
            return method.invoke(objectToInvokeMethodOn, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static class NoOpCloseHandler
    implements ConnectionCloseHandler {
        @Override
        public void close(Connection connection) {
        }

        @Override
        public void commit(Connection connection) {
        }
    }

    public static interface ConnectionCloseHandler {
        public void close(Connection var1);

        public void commit(Connection var1) throws SQLException;
    }
}

