/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.property;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.axonframework.common.property.MethodAccessedProperty;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMethodPropertyAccessStrategy
extends PropertyAccessStrategy {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public <T> Property<T> propertyFor(Class<? extends T> targetClass, String property) {
        String methodName = this.getterName(property);
        Optional<Method> method = this.getMethod(targetClass, methodName);
        if (!method.isPresent()) {
            logger.debug("No method with name '{}' found in {} to use as property accessor. Attempting to fall back to other strategies.", (Object)methodName, (Object)targetClass.getName());
            return null;
        }
        return new MethodAccessedProperty(method.get(), property);
    }

    private <T> Optional<Method> getMethod(Class<T> targetClass, String methodName) {
        return Arrays.stream(targetClass.getMethods()).filter(method -> method.getName().equals(methodName)).filter(method -> method.getParameterCount() == 0).filter(this::isNotReturningVoid).findFirst();
    }

    private boolean isNotReturningVoid(Method method) {
        boolean returnsVoid = method.getReturnType().equals(Void.TYPE);
        if (returnsVoid && logger.isDebugEnabled()) {
            logger.debug("Method with name '{}' in '{}' cannot be accepted as a property accessor, as it returns void", (Object)method.getName(), (Object)method.getDeclaringClass().getName());
        }
        return !returnsVoid;
    }

    protected abstract String getterName(String var1);
}

