/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.annotation;

import java.util.Map;
import javax.annotation.Nonnull;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.annotation.DeadlineHandler;
import org.axonframework.deadline.annotation.DeadlineHandlingMember;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;

public class DeadlineMethodMessageHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        return original.annotationAttributes(DeadlineHandler.class).map(attr -> new DeadlineMethodMessageHandlingMember(original, (Map)attr)).orElse(original);
    }

    private static class DeadlineMethodMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements DeadlineHandlingMember<T> {
        private final String deadlineName;

        private DeadlineMethodMessageHandlingMember(MessageHandlingMember<T> delegate, Map<String, Object> annotationAttributes) {
            super(delegate);
            this.deadlineName = (String)annotationAttributes.get("deadlineName");
        }

        @Override
        public boolean canHandle(@Nonnull Message<?> message) {
            return message instanceof DeadlineMessage && this.deadlineNameMatch((DeadlineMessage)message) && super.canHandle(message);
        }

        private boolean deadlineNameMatch(DeadlineMessage<?> message) {
            return this.deadlineNameMatchesAll() || this.deadlineName.equals(message.getDeadlineName());
        }

        private boolean deadlineNameMatchesAll() {
            return this.deadlineName.equals("");
        }

        @Override
        public int priority() {
            if (!this.deadlineNameMatchesAll()) {
                return 10000 + Math.min(2147473647, super.priority());
            }
            return 1000 + Math.min(2147482647, super.priority());
        }
    }
}

