/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.ThrowableCause;

public class JdbcDeadLetter<E extends EventMessage<?>>
implements DeadLetter<E> {
    private final String identifier;
    private final long sequenceIndex;
    private final String sequenceIdentifier;
    private final Instant enqueuedAt;
    private final Instant lastTouched;
    private final Cause cause;
    private final MetaData diagnostics;
    private final E message;

    public JdbcDeadLetter(String identifier, long index, String sequenceIdentifier, Instant enqueuedAt, Instant lastTouched, Cause cause, MetaData diagnostics, E message) {
        this.identifier = identifier;
        this.sequenceIndex = index;
        this.sequenceIdentifier = sequenceIdentifier;
        this.enqueuedAt = enqueuedAt;
        this.lastTouched = lastTouched;
        this.cause = cause;
        this.diagnostics = diagnostics;
        this.message = message;
    }

    @Override
    public E message() {
        return this.message;
    }

    @Override
    public Optional<Cause> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public Instant enqueuedAt() {
        return this.enqueuedAt;
    }

    @Override
    public Instant lastTouched() {
        return this.lastTouched;
    }

    @Override
    public MetaData diagnostics() {
        return this.diagnostics;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public long getSequenceIndex() {
        return this.sequenceIndex;
    }

    public String getSequenceIdentifier() {
        return this.sequenceIdentifier;
    }

    @Override
    public DeadLetter<E> markTouched() {
        return new JdbcDeadLetter<E>(this.identifier, this.sequenceIndex, this.sequenceIdentifier, this.enqueuedAt, GenericDeadLetter.clock.instant(), this.cause, this.diagnostics, this.message);
    }

    @Override
    public DeadLetter<E> withCause(Throwable requeueCause) {
        return new JdbcDeadLetter<E>(this.identifier, this.sequenceIndex, this.sequenceIdentifier, this.enqueuedAt, GenericDeadLetter.clock.instant(), requeueCause != null ? new ThrowableCause(requeueCause) : this.cause, this.diagnostics, this.message);
    }

    @Override
    public DeadLetter<E> withDiagnostics(MetaData diagnostics) {
        return new JdbcDeadLetter<E>(this.identifier, this.sequenceIndex, this.sequenceIdentifier, this.enqueuedAt, GenericDeadLetter.clock.instant(), this.cause, diagnostics, this.message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcDeadLetter that = (JdbcDeadLetter)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.sequenceIndex, that.sequenceIndex) && Objects.equals(this.sequenceIdentifier, that.sequenceIdentifier) && Objects.equals(this.enqueuedAt, that.enqueuedAt) && Objects.equals(this.lastTouched, that.lastTouched) && Objects.equals(this.cause, that.cause) && Objects.equals(this.diagnostics, that.diagnostics) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.sequenceIndex, this.sequenceIdentifier, this.enqueuedAt, this.lastTouched, this.cause, this.diagnostics, this.message);
    }

    public String toString() {
        return "JdbcDeadLetter{identifier='" + this.identifier + '\'' + ", sequenceIndex=" + this.sequenceIndex + ", sequenceIdentifier='" + this.sequenceIdentifier + '\'' + ", enqueuedAt=" + this.enqueuedAt + ", lastTouched=" + this.lastTouched + ", cause=" + this.cause + ", diagnostics=" + this.diagnostics + ", message=" + this.message + '}';
    }
}

