/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.correlation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.correlation.CorrelationDataProvider;

public class SimpleCorrelationDataProvider
implements CorrelationDataProvider {
    private final String[] headerNames;

    public SimpleCorrelationDataProvider(String ... metaDataKeys) {
        this.headerNames = Arrays.copyOf(metaDataKeys, metaDataKeys.length);
    }

    @Override
    public Map<String, ?> correlationDataFor(Message<?> message) {
        if (this.headerNames.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        MetaData metaData = message.getMetaData();
        for (String headerName : this.headerNames) {
            if (!metaData.containsKey(headerName)) continue;
            data.put(headerName, metaData.get(headerName));
        }
        return data;
    }
}

