/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.axonframework.serialization.CannotConvertBetweenTypesException;
import org.axonframework.serialization.ContentTypeConverter;

public class ByteArrayToJsonNodeConverter
implements ContentTypeConverter<byte[], JsonNode> {
    private final ObjectMapper objectMapper;

    public ByteArrayToJsonNodeConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Class<byte[]> expectedSourceType() {
        return byte[].class;
    }

    @Override
    public Class<JsonNode> targetType() {
        return JsonNode.class;
    }

    @Override
    public JsonNode convert(byte[] original) {
        try {
            return this.objectMapper.readTree(original);
        }
        catch (IOException e) {
            throw new CannotConvertBetweenTypesException("An error occurred while converting a JsonNode to byte[]", e);
        }
    }
}

