/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.Dom4JReader;
import com.thoughtworks.xstream.io.xml.XomReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import nu.xom.Document;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.serialization.AbstractXStreamSerializer;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.xml.CompactDriver;
import org.axonframework.serialization.xml.Dom4JToByteArrayConverter;
import org.axonframework.serialization.xml.InputStreamToDom4jConverter;
import org.axonframework.serialization.xml.InputStreamToXomConverter;
import org.axonframework.serialization.xml.XomToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamSerializer
extends AbstractXStreamSerializer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static XStreamSerializer defaultSerializer() {
        logger.warn("An unsecured XStream instance allowing all types is used. It is strongly recommended to set the security context yourself instead!", (Throwable)new AxonConfigurationException("An unsecured XStream instance allowing all types is used. It is strongly recommended to set the security context yourself instead!"));
        XStream xStream = new XStream((HierarchicalStreamDriver)new CompactDriver());
        xStream.allowTypeHierarchy(Object.class);
        return XStreamSerializer.builder().xStream(xStream).build();
    }

    protected XStreamSerializer(Builder builder) {
        super(builder);
    }

    @Override
    protected <T> T doSerialize(Object object, Class<T> expectedFormat, XStream xStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        xStream.toXML(object, (Writer)new OutputStreamWriter((OutputStream)baos, this.getCharset()));
        return this.convert(baos.toByteArray(), byte[].class, expectedFormat);
    }

    @Override
    public Object doDeserialize(SerializedObject serializedObject, XStream xStream) {
        if ("org.dom4j.Document".equals(serializedObject.getContentType().getName())) {
            return xStream.unmarshal((HierarchicalStreamReader)new Dom4JReader((org.dom4j.Document)serializedObject.getData()));
        }
        if ("nu.xom.Document".equals(serializedObject.getContentType().getName())) {
            return xStream.unmarshal((HierarchicalStreamReader)new XomReader((Document)serializedObject.getData()));
        }
        InputStream serializedData = this.convert(serializedObject.getData(), serializedObject.getContentType(), InputStream.class);
        return xStream.fromXML((Reader)new InputStreamReader(serializedData, this.getCharset()));
    }

    @Override
    protected void registerConverters(ChainingConverter converter) {
        converter.registerConverter(Dom4JToByteArrayConverter.class);
        converter.registerConverter(InputStreamToDom4jConverter.class);
        converter.registerConverter(XomToStringConverter.class);
        converter.registerConverter(InputStreamToXomConverter.class);
    }

    public static class Builder
    extends AbstractXStreamSerializer.Builder {
        @Override
        public Builder xStream(@Nonnull XStream xStream) {
            super.xStream(xStream);
            return this;
        }

        @Override
        public Builder charset(@Nonnull Charset charset) {
            super.charset(charset);
            return this;
        }

        @Override
        public Builder revisionResolver(@Nonnull RevisionResolver revisionResolver) {
            super.revisionResolver(revisionResolver);
            return this;
        }

        @Override
        public Builder converter(@Nonnull Converter converter) {
            super.converter(converter);
            return this;
        }

        @Override
        public Builder classLoader(@Nonnull ClassLoader classLoader) {
            super.classLoader(classLoader);
            return this;
        }

        @Override
        public Builder lenientDeserialization() {
            super.lenientDeserialization();
            return this;
        }

        @Override
        public Builder disableAxonTypeSecurity() {
            super.disableAxonTypeSecurity();
            return this;
        }

        @Override
        public Builder disableCachingOfUnknownClasses() {
            super.disableCachingOfUnknownClasses();
            return this;
        }

        public XStreamSerializer build() {
            if (this.xStream == null) {
                logger.warn("An unsecured XStream instance allowing all types is used. It is strongly recommended to set the security context yourself instead!", (Throwable)new AxonConfigurationException("An unsecured XStream instance allowing all types is used. It is strongly recommended to set the security context yourself instead!"));
                this.xStream = new XStream((HierarchicalStreamDriver)new CompactDriver());
            }
            return new XStreamSerializer(this);
        }
    }
}

