/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.axonframework.common.BuilderUtils;
import org.axonframework.updates.api.UpdateCheckRequest;
import org.axonframework.updates.api.UpdateCheckResponse;
import org.axonframework.updates.configuration.UsagePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckerHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCheckerHttpClient.class);
    private static final String BASE_FAILURE = "Failed to report anonymous usage data";
    private static final String STATUS_CODE_REF = "Received status code: {}";
    private static final int MAX_REDIRECTS = 5;
    private static final int HTTP_TEMP_REDIRECT = 307;
    private static final int HTTP_PERM_REDIRECT = 308;
    private final UsagePropertyProvider userProperties;

    public UpdateCheckerHttpClient(UsagePropertyProvider userProperties) {
        BuilderUtils.assertNonNull(userProperties, "The userProperties must not be null.");
        this.userProperties = userProperties;
    }

    public Optional<UpdateCheckResponse> sendRequest(UpdateCheckRequest updateCheckRequest, boolean firstRequest) {
        int redirects = 0;
        String queryString = updateCheckRequest.toQueryString();
        String url = this.userProperties.getUrl() + "?" + queryString;
        try {
            logger.debug("Reporting anonymous usage data to AxonIQ servers at: {}", (Object)url);
            while (redirects < 5) {
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.setInstanceFollowRedirects(false);
                connection.setRequestProperty("User-Agent", updateCheckRequest.toUserAgent());
                connection.setRequestProperty("X-Machine-Id", updateCheckRequest.machineId());
                connection.setRequestProperty("X-Instance-Id", updateCheckRequest.instanceId());
                connection.setRequestProperty("X-Uptime", String.valueOf(ManagementFactory.getRuntimeMXBean().getUptime()));
                connection.setRequestProperty("X-First-Run", firstRequest ? "true" : "false");
                int statusCode = connection.getResponseCode();
                if (statusCode == 200) {
                    String responseBody = this.readResponse(connection);
                    logger.debug("Reported anonymous usage data successfully, received response: {}", (Object)responseBody);
                    return Optional.of(UpdateCheckResponse.fromRequest(responseBody));
                }
                if (UpdateCheckerHttpClient.shouldRedirect(statusCode)) {
                    logger.debug("Received redirect request #{}. Received status code: {}", (Object)(++redirects), (Object)statusCode);
                    String redirect = connection.getHeaderField("Location");
                    if (redirect == null) {
                        logger.info("Failed to report anonymous usage data, due to missing location header on redirect. Received status code: {}", (Object)statusCode);
                        return Optional.empty();
                    }
                    url = UpdateCheckerHttpClient.removeQueryParameters(redirect) + "?" + queryString;
                    continue;
                }
                logger.info("Failed to report anonymous usage data. Received status code: {}", (Object)statusCode);
                return Optional.empty();
            }
            logger.warn("Failed to report anonymous usage data due to maximum amount of redirects.");
            return Optional.empty();
        }
        catch (Exception e) {
            logger.warn("Failed to report anonymous usage data.", (Throwable)e);
            return Optional.empty();
        }
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line).append("\n");
            }
            String string = response.toString();
            return string;
        }
    }

    private static boolean shouldRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308;
    }

    private static String removeQueryParameters(String redirect) {
        int queryParamIndex = redirect.indexOf(63);
        redirect = queryParamIndex != -1 ? redirect.substring(0, queryParamIndex) : redirect;
        return redirect;
    }
}

