/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.eventhandling.saga.repository;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Projections;
import java.util.Set;
import java.util.TreeSet;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.saga.AssociationValue;
import org.axonframework.eventhandling.saga.AssociationValues;
import org.axonframework.eventhandling.saga.repository.SagaStore;
import org.axonframework.mongo.MongoTemplate;
import org.axonframework.mongo.eventhandling.saga.repository.SagaEntry;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoSagaStore
implements SagaStore<Object> {
    private final MongoTemplate mongoTemplate;
    private final Serializer serializer;

    public MongoSagaStore(MongoTemplate mongoTemplate) {
        this(mongoTemplate, (Serializer)new XStreamSerializer());
    }

    public MongoSagaStore(MongoTemplate mongoTemplate, Serializer serializer) {
        Assert.notNull((Object)mongoTemplate, () -> "mongoTemplate may not be null");
        this.mongoTemplate = mongoTemplate;
        this.serializer = serializer;
    }

    public <S> SagaStore.Entry<S> loadSaga(Class<S> sagaType, String sagaIdentifier) {
        Document dbSaga = (Document)this.mongoTemplate.sagaCollection().find(SagaEntry.queryByIdentifier(sagaIdentifier)).first();
        if (dbSaga == null) {
            return null;
        }
        final SagaEntry sagaEntry = new SagaEntry(dbSaga);
        final Object loadedSaga = sagaEntry.getSaga(this.serializer);
        return new SagaStore.Entry<S>(){

            public Set<AssociationValue> associationValues() {
                return sagaEntry.getAssociationValues();
            }

            public S saga() {
                return loadedSaga;
            }
        };
    }

    public Set<String> findSagas(Class<?> sagaType, AssociationValue associationValue) {
        BasicDBObject value = this.associationValueQuery(sagaType, associationValue);
        MongoCursor dbCursor = this.mongoTemplate.sagaCollection().find((Bson)value).projection(Projections.include((String[])new String[]{"sagaIdentifier"})).iterator();
        TreeSet<String> found = new TreeSet<String>();
        while (dbCursor.hasNext()) {
            found.add((String)((Document)dbCursor.next()).get((Object)"sagaIdentifier"));
        }
        return found;
    }

    private BasicDBObject associationValueQuery(Class<?> sagaType, AssociationValue associationValue) {
        BasicDBObject value = new BasicDBObject();
        value.put((Object)"sagaType", (Object)this.getSagaTypeName(sagaType));
        BasicDBObject dbAssociation = new BasicDBObject();
        dbAssociation.put((Object)"key", (Object)associationValue.getKey());
        dbAssociation.put((Object)"value", (Object)associationValue.getValue());
        value.put((Object)"associations", (Object)dbAssociation);
        return value;
    }

    public void deleteSaga(Class<?> sagaType, String sagaIdentifier, Set<AssociationValue> associationValues) {
        this.mongoTemplate.sagaCollection().findOneAndDelete(SagaEntry.queryByIdentifier(sagaIdentifier));
    }

    public void updateSaga(Class<?> sagaType, String sagaIdentifier, Object saga, AssociationValues associationValues) {
        SagaEntry<Object> sagaEntry = new SagaEntry<Object>(sagaIdentifier, saga, associationValues.asSet(), this.serializer);
        this.mongoTemplate.sagaCollection().updateOne(SagaEntry.queryByIdentifier(sagaIdentifier), (Bson)new Document("$set", (Object)sagaEntry.asDocument()));
    }

    public void insertSaga(Class<?> sagaType, String sagaIdentifier, Object saga, Set<AssociationValue> associationValues) {
        SagaEntry<Object> sagaEntry = new SagaEntry<Object>(sagaIdentifier, saga, associationValues, this.serializer);
        Document sagaObject = sagaEntry.asDocument();
        this.mongoTemplate.sagaCollection().insertOne((Object)sagaObject);
    }

    private String getSagaTypeName(Class<?> sagaType) {
        return this.serializer.typeForClass(sagaType).getName();
    }
}

