/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.serialization;

import com.mongodb.DBObject;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.axonframework.mongo.serialization.BSONNode;

public class DBObjectHierarchicalStreamReader
implements HierarchicalStreamReader {
    private final Deque<BSONNode> itemStack = new ArrayDeque<BSONNode>();
    private final Deque<Iterator<BSONNode>> childrenStack = new ArrayDeque<Iterator<BSONNode>>();

    public DBObjectHierarchicalStreamReader(DBObject root) {
        BSONNode rootNode = BSONNode.fromDBObject(root);
        this.itemStack.push(rootNode);
        this.childrenStack.push(rootNode.children());
    }

    public boolean hasMoreChildren() {
        return this.childrenStack.peek().hasNext();
    }

    public void moveDown() {
        BSONNode currentNode = this.childrenStack.peek().next();
        this.itemStack.push(currentNode);
        this.childrenStack.push(currentNode.children());
    }

    public void moveUp() {
        this.itemStack.pop();
        this.childrenStack.pop();
    }

    public String getNodeName() {
        return this.itemStack.peek().getName();
    }

    public String getValue() {
        return this.itemStack.peek().getValue();
    }

    public String getAttribute(String name) {
        return this.itemStack.peek().getAttribute(name);
    }

    public String getAttribute(int index) {
        throw new UnsupportedOperationException("Index based attributes not supported, yet");
    }

    public int getAttributeCount() {
        return this.itemStack.peek().attributes().size();
    }

    public String getAttributeName(int index) {
        throw new UnsupportedOperationException("Index based attributes not supported, yet");
    }

    public Iterator getAttributeNames() {
        return this.itemStack.peek().attributes().keySet().iterator();
    }

    public void appendErrors(ErrorWriter errorWriter) {
    }

    public void close() {
    }

    public HierarchicalStreamReader underlyingReader() {
        return this;
    }
}

