/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.axon;

import io.axoniq.axonserver.grpc.event.QueryValue;
import io.axoniq.axonserver.grpc.event.RowResponse;
import java.util.List;
import java.util.stream.Collectors;

public class QueryResult {
    private static final QueryValue DEFAULT = QueryValue.newBuilder().build();
    private final RowResponse rowResponse;
    private final List<String> columns;

    public QueryResult(RowResponse nextItem, List<String> columns) {
        this.rowResponse = nextItem;
        this.columns = columns;
    }

    public Object get(String name) {
        return this.unwrap(this.rowResponse.getValuesOrDefault(name, DEFAULT));
    }

    public List<Object> getIdentifiers() {
        if (this.rowResponse.getIdValuesCount() == 0) {
            return null;
        }
        return this.rowResponse.getIdValuesList().stream().map(this::unwrap).collect(Collectors.toList());
    }

    public List<Object> getSortValues() {
        if (this.rowResponse.getSortValuesCount() == 0) {
            return null;
        }
        return this.rowResponse.getSortValuesList().stream().map(this::unwrap).collect(Collectors.toList());
    }

    public List<String> getColumns() {
        return this.columns;
    }

    private Object unwrap(QueryValue value) {
        switch (value.getDataCase()) {
            case TEXT_VALUE: {
                return value.getTextValue();
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case BOOLEAN_VALUE: {
                return value.getBooleanValue();
            }
            case DOUBLE_VALUE: {
                return value.getDoubleValue();
            }
        }
        return null;
    }

    public String toString() {
        return this.columns.stream().map(col -> col + "=" + this.get((String)col)).collect(Collectors.joining(","));
    }
}

