/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.serialization.SerializedObject;

public abstract class HeaderUtils {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String KEY_DELIMITER = "-";
    private static final String HEADERS_NULL_MESSAGE = "Headers may not be null";

    private HeaderUtils() {
    }

    public static Long asLong(byte[] value) {
        return value != null ? Long.valueOf(ByteBuffer.wrap(value).getLong()) : null;
    }

    public static Long valueAsLong(Headers headers, String key) {
        return HeaderUtils.asLong(HeaderUtils.value(headers, key));
    }

    public static Long valueAsLong(Headers headers, String key, Long defaultValue) {
        Long value = HeaderUtils.asLong(HeaderUtils.value(headers, key));
        return value != null ? value : defaultValue;
    }

    public static Integer asInt(byte[] value) {
        return value != null ? Integer.valueOf(ByteBuffer.wrap(value).getInt()) : null;
    }

    public static Integer valueAsInt(Headers headers, String key) {
        return HeaderUtils.asInt(HeaderUtils.value(headers, key));
    }

    public static Integer valueAsInt(Headers headers, String key, Integer defaultValue) {
        Integer value = HeaderUtils.asInt(HeaderUtils.value(headers, key));
        return value != null ? value : defaultValue;
    }

    public static String asString(byte[] value) {
        return value != null ? new String(value, UTF_8) : null;
    }

    public static String valueAsString(Headers headers, String key) {
        return HeaderUtils.asString(HeaderUtils.value(headers, key));
    }

    public static String valueAsString(Headers headers, String key, String defaultValue) {
        return Objects.toString(HeaderUtils.asString(HeaderUtils.value(headers, key)), defaultValue);
    }

    public static byte[] value(Headers headers, String key) {
        Assert.isTrue((headers != null ? 1 : 0) != 0, () -> HEADERS_NULL_MESSAGE);
        Header header = headers.lastHeader(key);
        return header != null ? header.value() : null;
    }

    public static byte[] toBytes(Number value) {
        if (value instanceof Short) {
            return HeaderUtils.toBytes((Short)value);
        }
        if (value instanceof Integer) {
            return HeaderUtils.toBytes((Integer)value);
        }
        if (value instanceof Long) {
            return HeaderUtils.toBytes((Long)value);
        }
        if (value instanceof Float) {
            return HeaderUtils.toBytes((Float)value);
        }
        if (value instanceof Double) {
            return HeaderUtils.toBytes((Double)value);
        }
        throw new IllegalArgumentException("Cannot convert [" + value + "] to bytes");
    }

    private static byte[] toBytes(Short value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value);
        return buffer.array();
    }

    private static byte[] toBytes(Integer value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        return buffer.array();
    }

    private static byte[] toBytes(Long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    private static byte[] toBytes(Float value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putFloat(value.floatValue());
        return buffer.array();
    }

    private static byte[] toBytes(Double value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putDouble(value);
        return buffer.array();
    }

    public static void addHeader(Headers headers, String key, Object value) {
        Assert.notNull((Object)headers, () -> "headers may not be null");
        if (value instanceof Instant) {
            headers.add(key, HeaderUtils.toBytes((Number)((Instant)value).toEpochMilli()));
        } else if (value instanceof Number) {
            headers.add(key, HeaderUtils.toBytes((Number)value));
        } else if (value instanceof String) {
            headers.add(key, ((String)value).getBytes(UTF_8));
        } else if (value == null) {
            headers.add(key, null);
        } else {
            headers.add(key, value.toString().getBytes(UTF_8));
        }
    }

    public static Set<String> keys(Headers headers) {
        Assert.notNull((Object)headers, () -> HEADERS_NULL_MESSAGE);
        return StreamSupport.stream(headers.spliterator(), false).map(Header::key).collect(Collectors.toSet());
    }

    public static String generateMetadataKey(String key) {
        return "axon-metadata-" + key;
    }

    public static String extractKey(String metaDataKey) {
        Assert.isTrue((metaDataKey != null && metaDataKey.startsWith("axon-metadata-") ? 1 : 0) != 0, () -> "Cannot extract Axon MetaData key from given String [" + metaDataKey + "]");
        return metaDataKey.substring("axon-metadata-".length());
    }

    public static Map<String, Object> extractAxonMetadata(Headers headers) {
        Assert.notNull((Object)headers, () -> HEADERS_NULL_MESSAGE);
        return StreamSupport.stream(headers.spliterator(), false).filter(header -> HeaderUtils.isValidMetadataKey(header.key())).collect(Collectors.toMap(header -> HeaderUtils.extractKey(header.key()), header -> HeaderUtils.asString(header.value())));
    }

    private static boolean isValidMetadataKey(String key) {
        return key.startsWith("axon-metadata-");
    }

    public static Headers toHeaders(EventMessage<?> eventMessage, SerializedObject<byte[]> serializedObject, BiFunction<String, Object, RecordHeader> headerValueMapper) {
        Assert.notNull(eventMessage, () -> "EventMessage may not be null");
        Assert.notNull(serializedObject, () -> "SerializedObject may not be null");
        Assert.notNull(headerValueMapper, () -> "Header key-value mapper function may not be null");
        RecordHeaders headers = new RecordHeaders();
        eventMessage.getMetaData().forEach((k, v) -> headers.add((Header)headerValueMapper.apply(HeaderUtils.generateMetadataKey(k), v)));
        org.axonframework.messaging.Headers.defaultHeaders(eventMessage, serializedObject).forEach((k, v) -> HeaderUtils.addHeader((Headers)headers, k, v));
        return headers;
    }

    public static BiFunction<String, Object, RecordHeader> byteMapper() {
        return (key, value) -> value instanceof byte[] ? new RecordHeader(key, (byte[])value) : new RecordHeader(key, HeaderUtils.safeGetBytes(value));
    }

    private static byte[] safeGetBytes(Object input) {
        if (input == null) {
            return null;
        }
        return input.toString().getBytes(UTF_8);
    }
}

