/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.axonframework.extensions.kafka.eventhandling.consumer.TopicListSubscriber;
import org.axonframework.extensions.kafka.eventhandling.consumer.TopicSubscriber;
import org.axonframework.extensions.kafka.eventhandling.consumer.streamable.KafkaTrackingToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerSeekUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private ConsumerSeekUtil() {
    }

    public static void seekToCurrentPositions(Consumer<?, ?> consumer, Supplier<KafkaTrackingToken> tokenSupplier, List<String> topics) {
        ConsumerSeekUtil.seekToCurrentPositions(consumer, tokenSupplier, new TopicListSubscriber(topics));
    }

    public static void seekToCurrentPositions(Consumer<?, ?> consumer, Supplier<KafkaTrackingToken> tokenSupplier, TopicSubscriber subscriber) {
        List<TopicPartition> all = ConsumerSeekUtil.topicPartitions(consumer, subscriber);
        consumer.assign(all);
        KafkaTrackingToken currentToken = tokenSupplier.get();
        Map<TopicPartition, Long> tokenPartitionPositions = currentToken.getPositions();
        all.forEach(assignedPartition -> {
            long offset = 0L;
            if (tokenPartitionPositions.containsKey(assignedPartition)) {
                offset = (Long)tokenPartitionPositions.get(assignedPartition) + 1L;
            }
            logger.info("Seeking topic-partition [{}] with offset [{}]", assignedPartition, (Object)offset);
            consumer.seek(assignedPartition, offset);
        });
    }

    public static List<TopicPartition> topicPartitions(Consumer<?, ?> consumer, List<String> topics) {
        return ConsumerSeekUtil.topicPartitions(consumer, new TopicListSubscriber(topics));
    }

    public static List<TopicPartition> topicPartitions(Consumer<?, ?> consumer, TopicSubscriber subscriber) {
        return consumer.listTopics().entrySet().stream().filter(e -> subscriber.subscribesToTopicName((String)e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).map(partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition())).collect(Collectors.toList());
    }
}

