/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.StringUtilities;
import com.strobel.expressions.BinaryExpression;
import com.strobel.expressions.BlockExpression;
import com.strobel.expressions.CatchBlock;
import com.strobel.expressions.ConcatExpression;
import com.strobel.expressions.ConditionalExpression;
import com.strobel.expressions.ConstantExpression;
import com.strobel.expressions.DefaultValueExpression;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.ForEachExpression;
import com.strobel.expressions.ForExpression;
import com.strobel.expressions.GotoExpression;
import com.strobel.expressions.InvocationExpression;
import com.strobel.expressions.LabelExpression;
import com.strobel.expressions.LabelTarget;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.LoopExpression;
import com.strobel.expressions.MemberExpression;
import com.strobel.expressions.MethodCallExpression;
import com.strobel.expressions.NewArrayExpression;
import com.strobel.expressions.NewExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.RuntimeVariablesExpression;
import com.strobel.expressions.SwitchCase;
import com.strobel.expressions.SwitchExpression;
import com.strobel.expressions.TryExpression;
import com.strobel.expressions.TypeBinaryExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.functions.Block;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import com.strobel.util.ContractUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;

final class DebugViewWriter
extends ExpressionVisitor {
    private static final int FLOW_NONE = 0;
    private static final int FLOW_SPACE = 1;
    private static final int FLOW_NEW_LINE = 2;
    private static final int FLOW_BREAK = 32768;
    private static final int TAB_SIZE = 4;
    private static final int MAX_COLUMN = 160;
    private final StringBuilder _out;
    private int _column;
    private int _delta;
    private int _flow;
    private final Deque<LambdaExpression> _lambdas = new ArrayDeque<LambdaExpression>();
    private final Map<LambdaExpression, Integer> _lambdaIds = new IdentityHashMap<LambdaExpression, Integer>();
    private final Map<ParameterExpression, Integer> _paramIds = new IdentityHashMap<ParameterExpression, Integer>();
    private final Map<LabelTarget, Integer> _labelIds = new IdentityHashMap<LabelTarget, Integer>();
    private final Block<? extends Expression> VISITOR_BLOCK = new Block<Expression>(){

        public void accept(Expression input) {
            DebugViewWriter.this.visit(input);
        }
    };

    private DebugViewWriter(StringBuilder out) {
        this._out = out;
    }

    private <T extends Expression> Block<T> visitorBlock() {
        return this.VISITOR_BLOCK;
    }

    private int base() {
        return 0;
    }

    private int delta() {
        return this._delta;
    }

    private int depth() {
        return this.base() + this.delta();
    }

    private void indent() {
        this._delta += 4;
    }

    private void unindent() {
        this._delta = Math.max(0, this._delta - 4);
    }

    private void newLine() {
        this._flow = 2;
    }

    private static <T> int getId(T e, Map<T, Integer> ids) {
        Integer id = ids.get(e);
        if (id == null) {
            id = ids.size() + 1;
            ids.put(e, id);
        }
        return id;
    }

    private int getLambdaId(LambdaExpression le) {
        assert (StringUtilities.isNullOrEmpty((String)le.getName()));
        return DebugViewWriter.getId(le, this._lambdaIds);
    }

    private int getParamId(ParameterExpression p) {
        assert (StringUtilities.isNullOrEmpty((String)p.getName()));
        return DebugViewWriter.getId(p, this._paramIds);
    }

    private int getLabelTargetId(LabelTarget target) {
        assert (StringUtilities.isNullOrEmpty((String)target.getName()));
        return DebugViewWriter.getId(target, this._labelIds);
    }

    private void out(char c) {
        this.out(0, c, 0);
    }

    private void out(char c, int after) {
        this.out(0, c, after);
    }

    private void out(int before, char c, int after) {
        switch (this.getFlow(before)) {
            case 0: {
                break;
            }
            case 1: {
                this.write(" ");
                break;
            }
            case 2: {
                this.writeLine();
                this.write(StringUtilities.repeat((char)' ', (int)this.depth()));
            }
        }
        this.write(c);
        this._flow = after;
    }

    private void out(String s) {
        this.out(0, s, 0);
    }

    private void out(int before, String s) {
        this.out(before, s, 0);
    }

    private void out(String s, int after) {
        this.out(0, s, after);
    }

    private void out(int before, String s, int after) {
        switch (this.getFlow(before)) {
            case 0: {
                break;
            }
            case 1: {
                this.write(" ");
                break;
            }
            case 2: {
                this.writeLine();
                this.write(StringUtilities.repeat((char)' ', (int)this.depth()));
            }
        }
        this.write(s);
        this._flow = after;
    }

    private void outMember(Expression node, Expression instance, MemberInfo member) {
        if (instance != null) {
            this.parenthesizedVisit(node, instance);
            this.out("." + member.getName());
        } else {
            this.out(member.getDeclaringType().toString() + "." + member.getName());
        }
    }

    private void writeLine() {
        this._out.append(System.lineSeparator());
        this._column = 0;
    }

    private void write(String s) {
        this._out.append(s);
        this._column += s.length();
    }

    private void write(char c) {
        this._out.append(c);
        ++this._column;
    }

    private int getFlow(int flow) {
        int last = this.checkBreak(this._flow);
        flow = this.checkBreak(flow);
        return Math.max(last, flow);
    }

    private int checkBreak(int flow) {
        if ((flow & 0x8000) != 0) {
            flow = this._column > 160 + this.depth() ? 2 : (flow &= 0xFFFF7FFF);
        }
        return flow;
    }

    static void writeTo(Expression node, StringBuilder writer) {
        assert (node != null);
        assert (writer != null);
        new DebugViewWriter(writer).writeTo(node);
    }

    private void writeTo(Expression node) {
        if (node instanceof LambdaExpression) {
            this.writeLambda((LambdaExpression)node);
        } else {
            this.visit(node);
        }
        while (!this._lambdas.isEmpty()) {
            this.writeLine();
            this.writeLine();
            this.writeLambda(this._lambdas.removeFirst());
        }
    }

    private void writeLambda(LambdaExpression lambda) {
        this.out(String.format(".Lambda %s<%s>", this.getLambdaName(lambda), lambda.getType()));
        this.visitDeclarations(lambda.getParameters());
        this.out(1, "{", 2);
        this.indent();
        this.visit(lambda.getBody());
        this.unindent();
        this.out(2, "}");
    }

    private <T extends Expression> void visitExpressions(char open, ExpressionList<T> expressions) {
        this.visitExpressions(open, ',', expressions);
    }

    private <T extends Expression> void visitExpressions(char open, char separator, ExpressionList<T> expressions) {
        this.visitExpressions(open, separator, expressions, this.visitorBlock());
    }

    private void visitDeclarations(ExpressionList<ParameterExpression> expressions) {
        this.visitExpressions('(', ',', expressions, new Block<ParameterExpression>(){

            public void accept(ParameterExpression variable) {
                DebugViewWriter.this.out(variable.getType().toString());
                DebugViewWriter.this.out(" ");
                DebugViewWriter.this.visitParameter(variable);
            }
        });
    }

    private <T extends Expression> void visitExpressions(char open, char separator, ExpressionList<T> expressions, Block<T> visit) {
        char close;
        this.out(open);
        if (expressions != null) {
            this.indent();
            boolean isFirst = true;
            for (Expression e : expressions) {
                if (isFirst) {
                    if (open == '{' || expressions.size() > 1) {
                        this.newLine();
                    }
                    isFirst = false;
                } else {
                    this.out(separator, 2);
                }
                visit.accept((Object)e);
            }
            this.unindent();
        }
        switch (open) {
            case '(': {
                close = ')';
                break;
            }
            case '{': {
                close = '}';
                break;
            }
            case '[': {
                close = ']';
                break;
            }
            case '<': {
                close = '>';
                break;
            }
            default: {
                throw ContractUtils.unreachable();
            }
        }
        if (open == '{') {
            this.newLine();
        }
        this.out(close, 32768);
    }

    private void writeLabel(LabelTarget target) {
        this.out(String.format(".LabelTarget %s:", this.getLabelTargetName(target)));
    }

    private static boolean isSimpleExpression(Expression node) {
        if (node instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)node;
            return !(binary.getLeft() instanceof BinaryExpression) && !(binary.getRight() instanceof BinaryExpression);
        }
        return false;
    }

    private static String getConstantValueSuffix(Type<?> type) {
        if (type.isPrimitive()) {
            switch (type.getKind()) {
                case BYTE: {
                    return "b";
                }
                case SHORT: {
                    return "s";
                }
                case LONG: {
                    return "L";
                }
                case FLOAT: {
                    return "f";
                }
                case DOUBLE: {
                    return "d";
                }
            }
        } else if (type == Types.BigDecimal) {
            return "m";
        }
        return null;
    }

    private static boolean containsWhiteSpace(String name) {
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(name.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String quoteName(String name) {
        return String.format("'%s'", name);
    }

    private static String getDisplayName(String name) {
        if (DebugViewWriter.containsWhiteSpace(name)) {
            return DebugViewWriter.quoteName(name);
        }
        return name;
    }

    private String getLambdaName(LambdaExpression lambda) {
        if (StringUtilities.isNullOrEmpty((String)lambda.getName())) {
            return "#Lambda" + this.getLambdaId(lambda);
        }
        return DebugViewWriter.getDisplayName(lambda.getName());
    }

    private String getLabelTargetName(LabelTarget target) {
        if (StringUtilities.isNullOrEmpty((String)target.getName())) {
            return String.format("#Label%s", this.getLabelTargetId(target));
        }
        return DebugViewWriter.getDisplayName(target.getName());
    }

    private String arrayToString(Object value) {
        Type type = Type.getType((Object)value);
        if (!type.isArray()) {
            return value.toString();
        }
        switch (type.getKind()) {
            case BOOLEAN: {
                return Arrays.toString((boolean[])value);
            }
            case BYTE: {
                return Arrays.toString((byte[])value);
            }
            case SHORT: {
                return Arrays.toString((short[])value);
            }
            case INT: {
                return Arrays.toString((int[])value);
            }
            case LONG: {
                return Arrays.toString((long[])value);
            }
            case CHAR: {
                return Arrays.toString((char[])value);
            }
            case FLOAT: {
                return Arrays.toString((float[])value);
            }
            case DOUBLE: {
                return Arrays.toString((double[])value);
            }
        }
        return Arrays.toString((Object[])value);
    }

    private void parenthesizedVisit(Expression parent, Expression nodeToVisit) {
        if (DebugViewWriter.needsParentheses(parent, nodeToVisit)) {
            this.out("(");
            this.visit(nodeToVisit);
            this.out(")");
        } else {
            this.visit(nodeToVisit);
        }
    }

    private static boolean needsParentheses(Expression parent, Expression child) {
        assert (parent != null);
        if (child == null) {
            return false;
        }
        switch (parent.getNodeType()) {
            case Increment: 
            case Decrement: 
            case IsTrue: 
            case IsFalse: 
            case Unbox: 
            case Convert: {
                return true;
            }
        }
        int childOpPrecedence = DebugViewWriter.getOperatorPrecedence(child);
        int parentOpPrecedence = DebugViewWriter.getOperatorPrecedence(parent);
        if (childOpPrecedence == parentOpPrecedence) {
            switch (parent.getNodeType()) {
                case AndAlso: 
                case OrElse: 
                case And: 
                case Or: 
                case ExclusiveOr: {
                    assert (child.getNodeType() == parent.getNodeType());
                    return false;
                }
                case Add: 
                case Multiply: {
                    return false;
                }
                case Subtract: 
                case Divide: 
                case Modulo: {
                    assert (parent instanceof BinaryExpression);
                    BinaryExpression binary = (BinaryExpression)parent;
                    return child == binary.getRight();
                }
            }
            return true;
        }
        if (child.getNodeType() == ExpressionType.Constant && parent.getNodeType() == ExpressionType.Negate) {
            return true;
        }
        return childOpPrecedence < parentOpPrecedence;
    }

    private static int getOperatorPrecedence(Expression node) {
        switch (node.getNodeType()) {
            case Assign: 
            case ExclusiveOrAssign: 
            case AddAssign: 
            case SubtractAssign: 
            case DivideAssign: 
            case ModuloAssign: 
            case MultiplyAssign: 
            case LeftShiftAssign: 
            case RightShiftAssign: 
            case AndAssign: 
            case OrAssign: 
            case Coalesce: {
                return 1;
            }
            case OrElse: {
                return 2;
            }
            case AndAlso: {
                return 3;
            }
            case Or: {
                return 4;
            }
            case ExclusiveOr: {
                return 5;
            }
            case And: {
                return 6;
            }
            case Equal: 
            case NotEqual: {
                return 7;
            }
            case GreaterThan: 
            case LessThan: 
            case GreaterThanOrEqual: 
            case LessThanOrEqual: 
            case InstanceOf: 
            case TypeEqual: {
                return 8;
            }
            case LeftShift: 
            case RightShift: 
            case UnsignedRightShift: {
                return 9;
            }
            case Add: 
            case Subtract: {
                return 10;
            }
            case Multiply: 
            case Divide: 
            case Modulo: {
                return 11;
            }
            case Increment: 
            case Decrement: 
            case IsTrue: 
            case IsFalse: 
            case Unbox: 
            case Convert: 
            case Negate: 
            case UnaryPlus: 
            case Not: 
            case ConvertChecked: 
            case PreIncrementAssign: 
            case PreDecrementAssign: 
            case OnesComplement: 
            case Throw: {
                return 12;
            }
            default: {
                return 14;
            }
            case Constant: 
            case Parameter: 
        }
        return 15;
    }

    @Override
    protected Expression visitBinary(BinaryExpression node) {
        if (node.getNodeType() == ExpressionType.ArrayIndex) {
            this.parenthesizedVisit(node, node.getLeft());
            this.out("[");
            this.visit(node.getRight());
            this.out("]");
        } else if (node.getNodeType() == ExpressionType.ArrayLength) {
            this.parenthesizedVisit(node, node.getLeft());
            this.out(".length");
        } else {
            String op;
            boolean parenthesizeLeft = DebugViewWriter.needsParentheses(node, node.getLeft());
            boolean parenthesizeRight = DebugViewWriter.needsParentheses(node, node.getRight());
            int beforeOp = 1;
            switch (node.getNodeType()) {
                case Assign: {
                    op = "=";
                    break;
                }
                case Equal: 
                case ReferenceEqual: {
                    op = "==";
                    break;
                }
                case NotEqual: 
                case ReferenceNotEqual: {
                    op = "!=";
                    break;
                }
                case AndAlso: {
                    op = "&&";
                    beforeOp = 32769;
                    break;
                }
                case OrElse: {
                    op = "||";
                    beforeOp = 32769;
                    break;
                }
                case GreaterThan: {
                    op = ">";
                    break;
                }
                case LessThan: {
                    op = "<";
                    break;
                }
                case GreaterThanOrEqual: {
                    op = ">=";
                    break;
                }
                case LessThanOrEqual: {
                    op = "<=";
                    break;
                }
                case Add: {
                    op = "+";
                    break;
                }
                case AddAssign: {
                    op = "+=";
                    break;
                }
                case Subtract: {
                    op = "-";
                    break;
                }
                case SubtractAssign: {
                    op = "-=";
                    break;
                }
                case Divide: {
                    op = "/";
                    break;
                }
                case DivideAssign: {
                    op = "/=";
                    break;
                }
                case Modulo: {
                    op = "%";
                    break;
                }
                case ModuloAssign: {
                    op = "%=";
                    break;
                }
                case Multiply: {
                    op = "*";
                    break;
                }
                case MultiplyAssign: {
                    op = "*=";
                    break;
                }
                case LeftShift: {
                    op = "<<";
                    break;
                }
                case LeftShiftAssign: {
                    op = "<<=";
                    break;
                }
                case RightShift: {
                    op = ">>";
                    break;
                }
                case UnsignedRightShift: {
                    op = ">>>";
                    break;
                }
                case RightShiftAssign: {
                    op = ">>=";
                    break;
                }
                case UnsignedRightShiftAssign: {
                    op = ">>>=";
                    break;
                }
                case And: {
                    op = "&";
                    break;
                }
                case AndAssign: {
                    op = "&=";
                    break;
                }
                case Or: {
                    op = "|";
                    break;
                }
                case OrAssign: {
                    op = "|=";
                    break;
                }
                case ExclusiveOr: {
                    op = "^";
                    break;
                }
                case ExclusiveOrAssign: {
                    op = "^=";
                    break;
                }
                case Coalesce: {
                    op = "??";
                    break;
                }
                default: {
                    throw ContractUtils.unreachable();
                }
            }
            if (parenthesizeLeft) {
                this.out("(", 0);
            }
            this.visit(node.getLeft());
            if (parenthesizeLeft) {
                this.out(0, ")", 32768);
            }
            this.out(beforeOp, op, 32769);
            if (parenthesizeRight) {
                this.out("(", 0);
            }
            this.visit(node.getRight());
            if (parenthesizeRight) {
                this.out(0, ")", 32768);
            }
        }
        return node;
    }

    @Override
    protected Expression visitParameter(ParameterExpression node) {
        this.out("$");
        if (StringUtilities.isNullOrEmpty((String)node.getName())) {
            int id = this.getParamId(node);
            this.out("var" + id);
        } else {
            this.out(DebugViewWriter.getDisplayName(node.getName()));
        }
        return node;
    }

    @Override
    protected <T> LambdaExpression<T> visitLambda(LambdaExpression<T> node) {
        this.out(String.format(".Lambda %s<%s>", this.getLambdaName(node), node.getType()));
        if (!this._lambdas.contains(node)) {
            this._lambdas.addLast(node);
        }
        return node;
    }

    @Override
    protected Expression visitConditional(ConditionalExpression node) {
        if (DebugViewWriter.isSimpleExpression(node.getTest())) {
            this.out(".If (");
            this.visit(node.getTest());
            this.out(") {", 2);
        } else {
            this.out(".If (", 2);
            this.indent();
            this.visit(node.getTest());
            this.unindent();
            this.out(2, ") {", 2);
        }
        this.indent();
        this.visit(node.getIfTrue());
        this.unindent();
        this.out(2, "} .Else {", 2);
        this.indent();
        this.visit(node.getIfFalse());
        this.unindent();
        this.out(2, "}");
        return node;
    }

    @Override
    protected Expression visitConstant(ConstantExpression node) {
        Object value = node.getValue();
        if (value == null) {
            this.out("null");
        } else if (value instanceof String && node.getType() == Types.String) {
            this.out(StringUtilities.escape((String)((String)value), (boolean)true));
        } else if (value instanceof Character && node.getType() == PrimitiveTypes.Character) {
            this.out(StringUtilities.escape((char)((Character)value).charValue(), (boolean)true));
        } else if (value instanceof Integer && node.getType() == PrimitiveTypes.Integer || value instanceof Boolean && node.getType() == PrimitiveTypes.Boolean) {
            this.out(value.toString());
        } else if (value instanceof Class && "java/lang/Class".equals(node.getType().getInternalName())) {
            this.out(((Class)value).getName() + ".class");
        } else if (value instanceof Type && "com/strobel/reflection/Type".equals(node.getType().getInternalName())) {
            this.out(((Type)value).getFullName() + ".class");
        } else {
            String suffix = DebugViewWriter.getConstantValueSuffix(node.getType());
            if (suffix != null) {
                this.out(String.valueOf(value));
                this.out(suffix);
            } else {
                String toString = value.getClass().isArray() ? this.arrayToString(value) : String.valueOf(value);
                this.out(String.format(".Constant<%s>(%s)", node.getType().toString(), toString));
            }
        }
        return node;
    }

    @Override
    protected Expression visitRuntimeVariables(RuntimeVariablesExpression node) {
        this.out(".RuntimeVariables");
        this.visitExpressions('(', node.getVariables());
        return node;
    }

    @Override
    protected Expression visitMember(MemberExpression node) {
        this.outMember(node, node.getTarget(), node.getMember());
        return node;
    }

    @Override
    protected Expression visitInvocation(InvocationExpression node) {
        this.out(".Invoke ");
        this.parenthesizedVisit(node, node.getExpression());
        this.visitExpressions('(', node.getArguments());
        return node;
    }

    @Override
    protected Expression visitMethodCall(MethodCallExpression node) {
        this.out(".Call ");
        if (node.getTarget() != null) {
            this.parenthesizedVisit(node, node.getTarget());
        } else if (node.getMethod().getDeclaringType() != null) {
            this.out(node.getMethod().getDeclaringType().toString());
        } else {
            this.out("<UnknownType>");
        }
        this.out(".");
        this.out(node.getMethod().getName());
        this.visitExpressions('(', node.getArguments());
        return node;
    }

    @Override
    protected Expression visitNewArray(NewArrayExpression node) {
        if (node.getNodeType() == ExpressionType.NewArrayBounds) {
            this.out(".NewArray " + node.getType().getElementType().toString());
            this.visitExpressions('[', node.getExpressions());
        } else {
            this.out(".NewArray " + node.getType().toString(), 1);
            this.visitExpressions('{', node.getExpressions());
        }
        return node;
    }

    @Override
    protected Expression visitNew(NewExpression node) {
        this.out(".New " + node.getType().toString());
        this.visitExpressions('(', node.getArguments());
        return node;
    }

    @Override
    protected Expression visitDefaultValue(DefaultValueExpression node) {
        this.out(".Default(" + node.getType().toString() + ")");
        return node;
    }

    @Override
    protected Expression visitExtension(Expression node) {
        this.out(String.format(".Extension<%s>", node.getClass().getName()));
        if (node.canReduce()) {
            this.out(1, "{", 2);
            this.indent();
            this.visit(node.reduce());
            this.unindent();
            this.out(2, "}");
        }
        return node;
    }

    @Override
    protected Expression visitLabel(LabelExpression node) {
        this.out(".Label", 2);
        this.indent();
        this.visit(node.getDefaultValue());
        this.unindent();
        this.newLine();
        this.writeLabel(node.getTarget());
        return node;
    }

    @Override
    protected LabelTarget visitLabelTarget(LabelTarget node) {
        this.writeLabel(node);
        return node;
    }

    @Override
    protected Expression visitGoto(GotoExpression node) {
        this.out("." + node.getKind().toString(), 1);
        this.out(this.getLabelTargetName(node.getTarget()), 1);
        this.out("{", 1);
        this.visit(node.getValue());
        this.out(1, "}");
        return node;
    }

    @Override
    protected Expression visitLoop(LoopExpression node) {
        this.out(".Loop", 1);
        if (node.getContinueTarget() != null) {
            this.writeLabel(node.getContinueTarget());
        }
        this.out(" {", 2);
        this.indent();
        this.visit(node.getBody());
        this.unindent();
        this.out(2, "}");
        if (node.getBreakTarget() != null) {
            this.out("", 2);
            this.writeLabel(node.getBreakTarget());
        }
        return node;
    }

    @Override
    protected Expression visitForEach(ForEachExpression node) {
        this.out(".ForEach", 1);
        this.out("(");
        this.visit(node.getVariable());
        this.out(" in ");
        this.visit(node.getSequence());
        this.out(") {", 2);
        this.indent();
        this.visit(node.getBody());
        this.unindent();
        this.out(2, "}");
        return node;
    }

    @Override
    protected Expression visitFor(ForExpression node) {
        this.out(".For", 1);
        this.out("(");
        this.visit(node.getVariable());
        this.out(" = ");
        this.visit(node.getInitializer());
        this.out("; ");
        this.visit(node.getTest());
        this.out("; ");
        this.visit(node.getStep());
        this.out(") {", 2);
        this.indent();
        this.visit(node.getBody());
        this.unindent();
        this.out(2, "}");
        return node;
    }

    @Override
    protected Expression visitUnary(UnaryExpression node) {
        String op;
        boolean parenthesize = DebugViewWriter.needsParentheses(node, node.getOperand());
        int beforeOp = 1;
        boolean trailing = false;
        Type<?> secondOp = null;
        switch (node.getNodeType()) {
            case Negate: {
                op = "-";
                break;
            }
            case Convert: {
                secondOp = node.getType();
            }
            case IsTrue: 
            case IsFalse: 
            case Unbox: 
            case Not: 
            case OnesComplement: 
            case Throw: 
            case ArrayLength: 
            case IsNull: 
            case IsNotNull: {
                op = "." + (Object)((Object)node.getNodeType());
                break;
            }
            case UnaryPlus: {
                op = "+";
                break;
            }
            case PostDecrementAssign: {
                trailing = true;
            }
            case PreDecrementAssign: {
                op = "--";
                break;
            }
            case PostIncrementAssign: {
                trailing = true;
            }
            case PreIncrementAssign: {
                op = "++";
                break;
            }
            default: {
                throw ContractUtils.unreachable();
            }
        }
        if (!trailing) {
            this.out(beforeOp, op, parenthesize ? 0 : 32769);
        }
        if (parenthesize) {
            this.out("(", 0);
        }
        this.visit(node.getOperand());
        if (parenthesize) {
            this.out(0, ")", 32768);
        }
        if (trailing) {
            this.out(beforeOp, op, parenthesize ? 0 : 32769);
        }
        return node;
    }

    @Override
    protected Expression visitTypeBinary(TypeBinaryExpression node) {
        this.visit(node.getOperand());
        this.out(" ");
        this.out(node.getNodeType() == ExpressionType.InstanceOf ? " .InstanceOf " : " .TypeEqual ");
        this.out(node.getType().toString());
        return node;
    }

    @Override
    protected Expression visitBlock(BlockExpression node) {
        this.out(".Block");
        if (node.getType() != node.getExpression(node.getExpressionCount() - 1).getType()) {
            this.out(String.format("<%s>", node.getType().toString()));
        }
        this.visitDeclarations(node.getVariables());
        this.out(" ");
        this.visitExpressions('{', ';', node.getExpressions());
        return node;
    }

    @Override
    protected Expression visitTry(TryExpression node) {
        this.out(".Try {", 2);
        this.indent();
        this.visit(node.getBody());
        this.unindent();
        DebugViewWriter.visit(node.getHandlers(), new ExpressionVisitor.ElementVisitor<CatchBlock>(){

            @Override
            public CatchBlock visit(CatchBlock node) {
                return DebugViewWriter.this.visitCatchBlock(node);
            }
        });
        if (node.getFinallyBlock() != null) {
            this.out(2, "} .Finally {", 2);
            this.indent();
            this.visit(node.getFinallyBlock());
            this.unindent();
        }
        this.out(2, "}");
        return node;
    }

    @Override
    protected CatchBlock visitCatchBlock(CatchBlock node) {
        this.out(2, "} .Catch (" + node.getTest().toString());
        if (node.getVariable() != null) {
            this.out(1, "");
            this.visitParameter(node.getVariable());
        }
        if (node.getFilter() != null) {
            this.out(") .If (", 32768);
            this.visit(node.getFilter());
        }
        this.out(") {", 2);
        this.indent();
        this.visit(node.getBody());
        this.unindent();
        return node;
    }

    @Override
    protected SwitchCase visitSwitchCase(SwitchCase node) {
        this.indent();
        for (Expression expression : node.getTestValues()) {
            this.out(".Case (");
            this.visit(expression);
            this.out("):", 2);
        }
        this.indent();
        this.visit(node.getBody());
        this.unindent();
        this.unindent();
        this.newLine();
        return node;
    }

    @Override
    protected Expression visitSwitch(SwitchExpression node) {
        this.out(".Switch ");
        this.out("(");
        this.visit(node.getSwitchValue());
        this.out(") {", 2);
        DebugViewWriter.visit(node.getCases(), new ExpressionVisitor.ElementVisitor<SwitchCase>(){

            @Override
            public SwitchCase visit(SwitchCase node) {
                return DebugViewWriter.this.visitSwitchCase(node);
            }
        });
        if (node.getDefaultBody() != null) {
            this.indent();
            this.out(".Default:", 2);
            this.indent();
            this.visit(node.getDefaultBody());
            this.unindent();
            this.unindent();
            this.newLine();
        }
        this.out("}");
        return node;
    }

    @Override
    protected Expression visitConcat(ConcatExpression node) {
        ExpressionList<? extends Expression> operands = node.getOperands();
        boolean first = true;
        for (Expression expression : operands) {
            if (first) {
                first = false;
            } else {
                this.out(1, "+", 32769);
            }
            boolean parenthesize = DebugViewWriter.needsParentheses(node, expression);
            if (parenthesize) {
                this.out("(", 0);
            }
            this.visit(expression);
            if (!parenthesize) continue;
            this.out(")", 0);
        }
        return node;
    }
}

