/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.BinaryExpression;
import com.strobel.expressions.ConstantCheck;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.util.TypeUtils;

final class Optimizer
extends ExpressionVisitor {
    private static final Optimizer OPTIMIZER = new Optimizer();

    Optimizer() {
    }

    static Expression optimize(Expression node) {
        return OPTIMIZER.visit(node);
    }

    static <T> LambdaExpression<T> optimize(LambdaExpression<T> node) {
        return OPTIMIZER.visitLambda(node);
    }

    @Override
    protected Expression visitBinary(BinaryExpression node) {
        Expression reduced = this.reduceNullConstantComparison(node);
        if (reduced != null) {
            return this.visit(reduced);
        }
        reduced = this.reduceBooleanConstantComparison(node);
        if (reduced != null) {
            return this.visit(reduced);
        }
        return super.visitBinary(node);
    }

    @Override
    protected Expression visitUnary(UnaryExpression node) {
        Expression reduced = this.reduceNullConstantCheck(node);
        if (reduced != null) {
            return this.visit(reduced);
        }
        reduced = this.reduceDoubleNot(node);
        if (reduced != null) {
            return this.visit(reduced);
        }
        return super.visitUnary(node);
    }

    private Expression reduceNullConstantCheck(UnaryExpression node) {
        Expression operand = node.getOperand();
        ExpressionType nodeType = node.getNodeType();
        ExpressionType operandNodeType = operand.getNodeType();
        if (nodeType == ExpressionType.IsNull) {
            if (ConstantCheck.isNull(operand)) {
                if (operandNodeType == ExpressionType.Parameter || operandNodeType == ExpressionType.Constant) {
                    return Expression.constant(Boolean.TRUE);
                }
                return Expression.block(operand, (Expression)Expression.constant(Boolean.TRUE));
            }
        } else if (nodeType == ExpressionType.IsNotNull && ConstantCheck.isNull(operand)) {
            if (operandNodeType == ExpressionType.Parameter || operandNodeType == ExpressionType.Constant) {
                return Expression.constant(Boolean.FALSE);
            }
            return Expression.block(operand, (Expression)Expression.constant(Boolean.FALSE));
        }
        return null;
    }

    private Expression reduceDoubleNot(UnaryExpression node) {
        Type<?> type = node.getType();
        Expression operand = node.getOperand();
        if (type != PrimitiveTypes.Boolean || operand.getType() != PrimitiveTypes.Boolean) {
            return null;
        }
        ExpressionType nodeType = node.getNodeType();
        ExpressionType operandNodeType = operand.getNodeType();
        if (!(nodeType != ExpressionType.Not && nodeType != ExpressionType.IsFalse || operandNodeType != ExpressionType.Not && operandNodeType != ExpressionType.IsFalse)) {
            return ((UnaryExpression)operand).getOperand();
        }
        return null;
    }

    private Expression reduceNullConstantComparison(BinaryExpression node) {
        Expression left = this.visit(node.getLeft());
        Expression right = this.visit(node.getRight());
        if (node.getType() != PrimitiveTypes.Boolean) {
            return null;
        }
        ExpressionType nodeType = node.getNodeType();
        switch (nodeType) {
            case Equal: 
            case NotEqual: 
            case ReferenceEqual: 
            case ReferenceNotEqual: {
                break;
            }
            default: {
                return null;
            }
        }
        if (ConstantCheck.isNull(right)) {
            if (ConstantCheck.isNull(left)) {
                return Expression.constant(nodeType == ExpressionType.Equal || nodeType == ExpressionType.ReferenceEqual);
            }
            return nodeType == ExpressionType.Equal || nodeType == ExpressionType.ReferenceEqual ? Expression.isNull(left) : Expression.isNotNull(left);
        }
        if (ConstantCheck.isNull(left)) {
            return nodeType == ExpressionType.Equal || nodeType == ExpressionType.ReferenceEqual ? Expression.isNull(right) : Expression.isNotNull(right);
        }
        return null;
    }

    private Expression reduceBooleanConstantComparison(BinaryExpression node) {
        Expression left = this.visit(node.getLeft());
        Expression right = this.visit(node.getRight());
        ExpressionType nodeType = node.getNodeType();
        if (node.getType() != PrimitiveTypes.Boolean || nodeType != ExpressionType.Equal && nodeType != ExpressionType.NotEqual) {
            return null;
        }
        if (ConstantCheck.isTrue(right)) {
            if (ConstantCheck.isTrue(left)) {
                return Expression.constant(nodeType == ExpressionType.Equal);
            }
            if (ConstantCheck.isFalse(left)) {
                return Expression.constant(nodeType == ExpressionType.NotEqual);
            }
            if (TypeUtils.getUnderlyingPrimitiveOrSelf(left.getType()) == PrimitiveTypes.Boolean) {
                return nodeType == ExpressionType.Equal ? left : Expression.isFalse(left);
            }
            return null;
        }
        if (ConstantCheck.isFalse(right)) {
            if (ConstantCheck.isFalse(left)) {
                return Expression.constant(nodeType == ExpressionType.Equal);
            }
            if (ConstantCheck.isTrue(left)) {
                return Expression.constant(nodeType == ExpressionType.NotEqual);
            }
            if (TypeUtils.getUnderlyingPrimitiveOrSelf(left.getType()) == PrimitiveTypes.Boolean) {
                return nodeType == ExpressionType.Equal ? Expression.isFalse(left) : left;
            }
            return null;
        }
        if (ConstantCheck.isTrue(left)) {
            if (TypeUtils.getUnderlyingPrimitiveOrSelf(right.getType()) == PrimitiveTypes.Boolean) {
                return nodeType == ExpressionType.Equal ? right : Expression.isFalse(right);
            }
        } else if (ConstantCheck.isFalse(left) && TypeUtils.getUnderlyingPrimitiveOrSelf(right.getType()) == PrimitiveTypes.Boolean) {
            return nodeType == ExpressionType.NotEqual ? right : Expression.isFalse(right);
        }
        return null;
    }
}

