/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.tek.nik.simplifiedswagger.swaggerdecorators;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import org.bitbucket.tek.nik.simplifiedswagger.newmodels.NewModelCreator;
import org.bitbucket.tek.nik.simplifiedswagger.swaggerdecorators.ISwaggerDecorator;

public class ApiOperationSwaggerDecorator
implements ISwaggerDecorator {
    @Override
    public void decorateProperty(Property property, Annotation annotation, Class propertyType) {
    }

    @Override
    public void decorateParameter(Parameter parameter, Annotation annotation, java.lang.reflect.Parameter methodParameter) {
    }

    @Override
    public void decorateModel(Model model, Annotation annotation, Class modelClass) {
    }

    @Override
    public void decorateOperation(Operation operation, Annotation annotation, Method method, NewModelCreator newModelCreator) {
        Extension[] extensions;
        String[] tags;
        ApiOperation apiOperation = (ApiOperation)annotation;
        String value = apiOperation.value();
        String notes = apiOperation.notes();
        operation.setSummary(value);
        operation.setDescription(notes);
        Authorization[] authorizations = apiOperation.authorizations();
        ApiOperationSwaggerDecorator.applyAuthorizationsOnOperation(operation, authorizations);
        this.addConsumesOrProduces(operation, apiOperation.consumes(), (message, operation1) -> operation1.addConsumes(message), operation1 -> operation1.getConsumes() == null || operation1.getConsumes().size() == 0);
        this.addConsumesOrProduces(operation, apiOperation.produces(), (message, operation1) -> operation1.addProduces(message), operation1 -> operation1.getProduces() == null || operation1.getProduces().size() == 0);
        String nickname = apiOperation.nickname();
        if (nickname != null && nickname.length() > 0) {
            operation.setOperationId(nickname);
        }
        if (apiOperation.hidden()) {
            operation.getVendorExtensions().put("hidden", apiOperation.hidden());
        }
        if ((tags = apiOperation.tags()) != null && tags.length > 0) {
            for (String tag : tags) {
                if (tag == null || tag.length() == 0) continue;
                operation.addTag(tag);
            }
        }
        for (Extension extension : extensions = apiOperation.extensions()) {
            ExtensionProperty[] properties;
            String extensionName = extension.name();
            for (ExtensionProperty extensionProperty : properties = extension.properties()) {
                String extensionPropertyName = extensionProperty.name();
                String extensionPropertyValue = extensionProperty.value();
                HashMap<String, String> map = new HashMap<String, String>();
                if (extensionPropertyName != null && extensionPropertyName.length() != 0) {
                    map.put(extensionPropertyName, extensionPropertyValue);
                }
                operation.getVendorExtensions().put("x-" + extensionName, map);
            }
        }
    }

    public static void applyAuthorizationsOnOperation(Operation operation, Authorization[] authorizations) {
        if (authorizations != null) {
            for (Authorization authorization : authorizations) {
                AuthorizationScope[] authScopes = authorization.scopes();
                ArrayList<String> scopes = new ArrayList<String>();
                for (AuthorizationScope authorizationScope : authScopes) {
                    String scope = authorizationScope.scope();
                    if (scope == null || scope.length() <= 0) continue;
                    scopes.add(scope);
                }
                operation.addSecurity(authorization.value(), scopes);
            }
        }
    }

    private void addConsumesOrProduces(Operation operation, String inputToAdd, SendStringToOperation fobj, Function<Operation, Boolean> previouslyEmpty) {
        if (inputToAdd != null && previouslyEmpty.apply(operation).booleanValue() && (inputToAdd = inputToAdd.trim()).length() > 0) {
            String[] inputToAddArr;
            for (String inputToAddArrRow : inputToAddArr = inputToAdd.split(",")) {
                if ((inputToAddArrRow = inputToAddArrRow.trim()).length() <= 0) continue;
                fobj.apply(inputToAddArrRow, operation);
            }
        }
    }

    static interface SendStringToOperation {
        public void apply(String var1, Operation var2);
    }
}

