/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SignatureOutputStream;

public class JcaPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcaPGPContentVerifierBuilderProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcaPGPContentVerifierBuilderProvider setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new JcaPGPContentVerifierBuilder(n, n2);
    }

    private class JcaPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public JcaPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        public PGPContentVerifier build(PGPPublicKey pGPPublicKey) throws PGPException {
            Signature signature = JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
            try {
                signature.initVerify(JcaPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PGPException("invalid key.", invalidKeyException);
            }
            return new PGPContentVerifier(this, pGPPublicKey, signature){
                private final /* synthetic */ PGPPublicKey val$publicKey;
                private final /* synthetic */ Signature val$signature;
                private final /* synthetic */ JcaPGPContentVerifierBuilder this$1;
                {
                    this.this$1 = jcaPGPContentVerifierBuilder;
                    this.val$publicKey = pGPPublicKey;
                    this.val$signature = signature;
                }

                public int getHashAlgorithm() {
                    return JcaPGPContentVerifierBuilder.access$200(this.this$1);
                }

                public int getKeyAlgorithm() {
                    return JcaPGPContentVerifierBuilder.access$300(this.this$1);
                }

                public long getKeyID() {
                    return this.val$publicKey.getKeyID();
                }

                public boolean verify(byte[] byArray) {
                    try {
                        return this.val$signature.verify(byArray);
                    }
                    catch (SignatureException signatureException) {
                        throw new PGPRuntimeOperationException("unable to verify signature: " + signatureException.getMessage(), signatureException);
                    }
                }

                public OutputStream getOutputStream() {
                    return new SignatureOutputStream(this.val$signature);
                }
            };
        }

        static /* synthetic */ int access$200(JcaPGPContentVerifierBuilder jcaPGPContentVerifierBuilder) {
            return jcaPGPContentVerifierBuilder.hashAlgorithm;
        }

        static /* synthetic */ int access$300(JcaPGPContentVerifierBuilder jcaPGPContentVerifierBuilder) {
            return jcaPGPContentVerifierBuilder.keyAlgorithm;
        }
    }
}

