/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public final class XMSSPrivateKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSParameters params;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final BDS bdsState;

    private XMSSPrivateKeyParameters(Builder builder) {
        super(true);
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getDigestSize();
        byte[] privateKey = builder.privateKey;
        if (privateKey != null) {
            if (builder.xmss == null) {
                throw new NullPointerException("xmss == null");
            }
            int height = this.params.getHeight();
            int indexSize = 4;
            int secretKeySize = n;
            int secretKeyPRFSize = n;
            int publicSeedSize = n;
            int rootSize = n;
            int position = 0;
            int index = Pack.bigEndianToInt(privateKey, position);
            if (!XMSSUtil.isIndexValid(height, index)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset(privateKey, position += indexSize, secretKeySize);
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset(privateKey, position += secretKeySize, secretKeyPRFSize);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(privateKey, position += secretKeyPRFSize, publicSeedSize);
            this.root = XMSSUtil.extractBytesAtOffset(privateKey, position += publicSeedSize, rootSize);
            byte[] bdsStateBinary = XMSSUtil.extractBytesAtOffset(privateKey, position += rootSize, privateKey.length - position);
            BDS bdsImport = null;
            try {
                bdsImport = (BDS)XMSSUtil.deserialize(bdsStateBinary);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            bdsImport.setXMSS(builder.xmss);
            bdsImport.validate();
            if (bdsImport.getIndex() != index) {
                throw new IllegalStateException("serialized BDS has wrong index");
            }
            this.bdsState = bdsImport;
        } else {
            byte[] tmpSecretKeySeed = builder.secretKeySeed;
            if (tmpSecretKeySeed != null) {
                if (tmpSecretKeySeed.length != n) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.secretKeySeed = tmpSecretKeySeed;
            } else {
                this.secretKeySeed = new byte[n];
            }
            byte[] tmpSecretKeyPRF = builder.secretKeyPRF;
            if (tmpSecretKeyPRF != null) {
                if (tmpSecretKeyPRF.length != n) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.secretKeyPRF = tmpSecretKeyPRF;
            } else {
                this.secretKeyPRF = new byte[n];
            }
            byte[] tmpPublicSeed = builder.publicSeed;
            if (tmpPublicSeed != null) {
                if (tmpPublicSeed.length != n) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.publicSeed = tmpPublicSeed;
            } else {
                this.publicSeed = new byte[n];
            }
            byte[] tmpRoot = builder.root;
            if (tmpRoot != null) {
                if (tmpRoot.length != n) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.root = tmpRoot;
            } else {
                this.root = new byte[n];
            }
            BDS tmpBDSState = builder.bdsState;
            this.bdsState = tmpBDSState != null ? tmpBDSState : (builder.index < (1 << this.params.getHeight()) - 2 && tmpPublicSeed != null && tmpSecretKeySeed != null ? new BDS(this.params, tmpPublicSeed, tmpSecretKeySeed, (OTSHashAddress)new OTSHashAddress.Builder().build(), builder.index) : new BDS(this.params, builder.index));
        }
    }

    public byte[] toByteArray() {
        int n = this.params.getDigestSize();
        int indexSize = 4;
        int secretKeySize = n;
        int secretKeyPRFSize = n;
        int publicSeedSize = n;
        int rootSize = n;
        int totalSize = indexSize + secretKeySize + secretKeyPRFSize + publicSeedSize + rootSize;
        byte[] out = new byte[totalSize];
        int position = 0;
        Pack.intToBigEndian(this.bdsState.getIndex(), out, position);
        XMSSUtil.copyBytesAtOffset(out, this.secretKeySeed, position += indexSize);
        XMSSUtil.copyBytesAtOffset(out, this.secretKeyPRF, position += secretKeySize);
        XMSSUtil.copyBytesAtOffset(out, this.publicSeed, position += secretKeyPRFSize);
        XMSSUtil.copyBytesAtOffset(out, this.root, position += publicSeedSize);
        byte[] bdsStateOut = null;
        try {
            bdsStateOut = XMSSUtil.serialize(this.bdsState);
        }
        catch (IOException e) {
            throw new RuntimeException("error serializing bds state: " + e.getMessage());
        }
        return Arrays.concatenate(out, bdsStateOut);
    }

    public int getIndex() {
        return this.bdsState.getIndex();
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    BDS getBDSState() {
        return this.bdsState;
    }

    public XMSSParameters getParameters() {
        return this.params;
    }

    public XMSSPrivateKeyParameters getNextKey() {
        int treeHeight = this.params.getHeight();
        if (this.getIndex() < (1 << treeHeight) - 1) {
            return new Builder(this.params).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withBDSState(this.bdsState.getNextState(this.publicSeed, this.secretKeySeed, (OTSHashAddress)new OTSHashAddress.Builder().build())).build();
        }
        return new Builder(this.params).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withBDSState(new BDS(this.params, this.getIndex() + 1)).build();
    }

    public static class Builder {
        private final XMSSParameters params;
        private int index = 0;
        private byte[] secretKeySeed = null;
        private byte[] secretKeyPRF = null;
        private byte[] publicSeed = null;
        private byte[] root = null;
        private BDS bdsState = null;
        private byte[] privateKey = null;
        private XMSSParameters xmss = null;

        public Builder(XMSSParameters params) {
            this.params = params;
        }

        public Builder withIndex(int val) {
            this.index = val;
            return this;
        }

        public Builder withSecretKeySeed(byte[] val) {
            this.secretKeySeed = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] val) {
            this.secretKeyPRF = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.publicSeed = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withRoot(byte[] val) {
            this.root = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withBDSState(BDS valBDS) {
            this.bdsState = valBDS;
            return this;
        }

        public Builder withPrivateKey(byte[] privateKeyVal, XMSSParameters xmssParameters) {
            this.privateKey = XMSSUtil.cloneArray(privateKeyVal);
            this.xmss = xmssParameters;
            return this;
        }

        public XMSSPrivateKeyParameters build() {
            return new XMSSPrivateKeyParameters(this);
        }
    }
}

