/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.its.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.its.asn1.BitmapSspRange;
import org.bouncycastle.its.asn1.SequenceOfOctetString;

public class SspRange
extends ASN1Object {
    private final boolean isAll;
    private final SequenceOfOctetString opaque;
    private final BitmapSspRange bitmapSspRange;

    private SspRange() {
        this.isAll = true;
        this.opaque = null;
        this.bitmapSspRange = null;
    }

    private SspRange(SequenceOfOctetString seq) {
        this.isAll = false;
        if (seq.size() != 2) {
            this.opaque = seq;
            this.bitmapSspRange = null;
        } else {
            BitmapSspRange bitMapRange;
            this.opaque = SequenceOfOctetString.getInstance(seq);
            try {
                bitMapRange = BitmapSspRange.getInstance(seq);
            }
            catch (IllegalArgumentException e) {
                bitMapRange = null;
            }
            this.bitmapSspRange = bitMapRange;
        }
    }

    public SspRange(BitmapSspRange range) {
        this.isAll = false;
        this.bitmapSspRange = range;
        this.opaque = null;
    }

    public static SspRange getInstance(Object src) {
        if (src == null) {
            return null;
        }
        if (src instanceof SspRange) {
            return (SspRange)src;
        }
        if (src instanceof ASN1Null) {
            return new SspRange();
        }
        if (src instanceof ASN1Sequence) {
            return new SspRange(SequenceOfOctetString.getInstance(src));
        }
        if (src instanceof byte[]) {
            try {
                return SspRange.getInstance(ASN1Primitive.fromByteArray((byte[])src));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to parse encoded general name");
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + src.getClass().getName());
    }

    public boolean isAll() {
        return this.isAll;
    }

    public boolean maybeOpaque() {
        return this.opaque != null;
    }

    public BitmapSspRange getBitmapSspRange() {
        return this.bitmapSspRange;
    }

    public SequenceOfOctetString getOpaque() {
        return this.opaque;
    }

    public ASN1Primitive toASN1Primitive() {
        if (this.isAll) {
            return DERNull.INSTANCE;
        }
        if (this.bitmapSspRange != null) {
            return this.bitmapSspRange.toASN1Primitive();
        }
        return this.opaque.toASN1Primitive();
    }
}

