/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SHA512tDigest;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSParamSpec;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import org.bouncycastle.jcajce.util.BCJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;

public class PSSSignatureSpi
extends Signature {
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private AlgorithmParameters engineParams;
    private PSSParameterSpec paramSpec;
    private AsymmetricBlockCipher signer;
    private Digest contentDigest;
    private Digest mgfDigest;
    private int saltLength;
    private byte trailer;
    private boolean isRaw;
    private PSSSigner pss;

    private byte getTrailer(int n) {
        if (n == 1) {
            return -68;
        }
        throw new IllegalArgumentException("unknown trailer field");
    }

    private void setupContentDigest() {
        this.contentDigest = this.isRaw ? new NullPssDigest(this.mgfDigest) : this.mgfDigest;
    }

    protected PSSSignatureSpi(String string, AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        super(string);
        this.signer = asymmetricBlockCipher;
        if (digest != null) {
            this.saltLength = digest.getDigestSize();
            this.mgfDigest = digest;
        } else {
            this.saltLength = 20;
        }
        if (this.paramSpec != null) {
            this.saltLength = this.paramSpec.getSaltLength();
        }
        this.isRaw = false;
        this.setupContentDigest();
    }

    protected PSSSignatureSpi(String string, AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl) {
        super(string);
        this.signer = asymmetricBlockCipher;
        if (digest != null) {
            this.saltLength = digest.getDigestSize();
            this.mgfDigest = digest;
        } else {
            this.saltLength = 20;
        }
        if (this.paramSpec != null) {
            this.saltLength = this.paramSpec.getSaltLength();
        }
        this.isRaw = bl;
        this.setupContentDigest();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
        }
        if (this.mgfDigest == null) {
            this.mgfDigest = new SHA1Digest();
            this.setupContentDigest();
        }
        this.pss = new PSSSigner(this.signer, this.contentDigest, this.mgfDigest, this.saltLength);
        this.pss.init(false, RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey));
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        if (this.mgfDigest == null) {
            this.mgfDigest = new SHA1Digest();
            this.setupContentDigest();
        }
        this.pss = new PSSSigner(this.signer, this.contentDigest, this.mgfDigest, this.saltLength);
        this.pss.init(true, new ParametersWithRandom(RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey), secureRandom));
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        if (this.mgfDigest == null) {
            this.mgfDigest = new SHA1Digest();
            this.setupContentDigest();
        }
        this.pss = new PSSSigner(this.signer, this.contentDigest, this.mgfDigest, this.saltLength);
        this.pss.init(true, RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey));
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.pss.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.pss.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.pss.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException(cryptoException.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.pss.verifySignature(byArray);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterException {
        if (algorithmParameterSpec instanceof PSSParameterSpec) {
            PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            this.engineParams = null;
            this.paramSpec = pSSParameterSpec;
            this.saltLength = this.paramSpec.getSaltLength();
            boolean bl = false;
            if (this.paramSpec instanceof PSSParamSpec) {
                bl = ((PSSParamSpec)this.paramSpec).getDigestName().startsWith("SHA3");
            }
            if (this.mgfDigest == null) {
                switch (this.saltLength) {
                    case 20: {
                        this.mgfDigest = new SHA1Digest();
                        break;
                    }
                    case 28: {
                        if (bl) {
                            this.mgfDigest = new SHA3Digest(224);
                            break;
                        }
                        this.mgfDigest = new SHA224Digest();
                        break;
                    }
                    case 32: {
                        if (bl) {
                            this.mgfDigest = new SHA3Digest(256);
                            break;
                        }
                        this.mgfDigest = new SHA256Digest();
                        break;
                    }
                    case 48: {
                        if (bl) {
                            this.mgfDigest = new SHA3Digest(384);
                            break;
                        }
                        this.mgfDigest = new SHA384Digest();
                        break;
                    }
                    case 64: {
                        if (bl) {
                            this.mgfDigest = new SHA3Digest(512);
                            break;
                        }
                        this.mgfDigest = new SHA512Digest();
                        break;
                    }
                    default: {
                        if (this.saltLength <= 20) {
                            this.mgfDigest = new SHA1Digest();
                            break;
                        }
                        if (this.saltLength <= 28) {
                            this.mgfDigest = new SHA224Digest();
                            break;
                        }
                        if (this.saltLength > 32) break;
                        this.mgfDigest = new SHA256Digest();
                    }
                }
                this.setupContentDigest();
            }
        } else {
            throw new InvalidParameterException("Only PSSParameterSpec supported");
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            try {
                this.engineParams = this.helper.createAlgorithmParameters("PSS");
                this.engineParams.init(new PSSParameterSpec(this.saltLength));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    private class NullPssDigest
    implements Digest {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        private Digest baseDigest;
        private boolean oddTime = true;

        public NullPssDigest(Digest digest) {
            this.baseDigest = digest;
        }

        public String getAlgorithmName() {
            return "NULL";
        }

        public int getDigestSize() {
            return this.baseDigest.getDigestSize();
        }

        public void update(byte by) {
            this.bOut.write(by);
        }

        public void update(byte[] byArray, int n, int n2) {
            this.bOut.write(byArray, n, n2);
        }

        public int doFinal(byte[] byArray, int n) {
            byte[] byArray2 = this.bOut.toByteArray();
            if (this.oddTime) {
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            } else {
                this.baseDigest.update(byArray2, 0, byArray2.length);
                this.baseDigest.doFinal(byArray, n);
            }
            this.reset();
            this.oddTime = !this.oddTime;
            return byArray2.length;
        }

        public void reset() {
            this.bOut.reset();
            this.baseDigest.reset();
        }

        public int getByteLength() {
            return 0;
        }
    }

    public static class SHA3_512withRSA
    extends PSSSignatureSpi {
        public SHA3_512withRSA() {
            super("SHA3-512withRSAandMGF1", new RSABlindedEngine(), new SHA3Digest(512));
        }
    }

    public static class SHA3_384withRSA
    extends PSSSignatureSpi {
        public SHA3_384withRSA() {
            super("SHA3-384withRSAandMGF1", new RSABlindedEngine(), new SHA3Digest(384));
        }
    }

    public static class SHA3_256withRSA
    extends PSSSignatureSpi {
        public SHA3_256withRSA() {
            super("SHA3-256withRSAandMGF1", new RSABlindedEngine(), new SHA3Digest(256));
        }
    }

    public static class SHA3_224withRSA
    extends PSSSignatureSpi {
        public SHA3_224withRSA() {
            super("SHA3-224withRSAandMGF1", new RSABlindedEngine(), new SHA3Digest(224));
        }
    }

    public static class SHA512_256withRSA
    extends PSSSignatureSpi {
        public SHA512_256withRSA() {
            super("SHA512(256)withRSAandMGF1", new RSABlindedEngine(), new SHA512tDigest(256));
        }
    }

    public static class SHA512_224withRSA
    extends PSSSignatureSpi {
        public SHA512_224withRSA() {
            super("SHA512(224)withRSAandMGF1", new RSABlindedEngine(), new SHA512tDigest(224));
        }
    }

    public static class SHA512withRSA
    extends PSSSignatureSpi {
        public SHA512withRSA() {
            super("SHA512withRSAandMGF1", new RSABlindedEngine(), new SHA512Digest());
        }
    }

    public static class SHA384withRSA
    extends PSSSignatureSpi {
        public SHA384withRSA() {
            super("SHA384withRSAandMGF1", new RSABlindedEngine(), new SHA384Digest());
        }
    }

    public static class SHA256withRSA
    extends PSSSignatureSpi {
        public SHA256withRSA() {
            super("SHA256withRSAandMGF1", new RSABlindedEngine(), new SHA256Digest());
        }
    }

    public static class SHA224withRSA
    extends PSSSignatureSpi {
        public SHA224withRSA() {
            super("SHA224withRSAandMGF1", new RSABlindedEngine(), new SHA224Digest());
        }
    }

    public static class SHA1withRSA
    extends PSSSignatureSpi {
        public SHA1withRSA() {
            super("SHA1withRSAandMGF1", new RSABlindedEngine(), new SHA1Digest());
        }
    }

    public static class PSSwithRSA
    extends PSSSignatureSpi {
        public PSSwithRSA() {
            super("SHA1withRSAandMGF1", new RSABlindedEngine(), null);
        }
    }

    public static class nonePSS
    extends PSSSignatureSpi {
        public nonePSS() {
            super("NONEwithRSAandMGF1", new RSABlindedEngine(), null, true);
        }
    }
}

