/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Longs;

abstract class AsconBaseEngine
implements AEADCipher {
    protected static final int UNINITIALIZED = 0;
    protected static final int ENCINIT = 1;
    protected static final int ENCAAD = 2;
    protected static final int ENCDATA = 3;
    protected static final int ENCFINAL = 4;
    protected static final int DECINIT = 5;
    protected static final int DECAAD = 6;
    protected static final int DECDATA = 7;
    protected static final int DECFINAL = 8;
    protected static final State Uninitialized = new State(0);
    protected static final State EncInit = new State(1);
    protected static final State EncAad = new State(2);
    protected static final State EncData = new State(3);
    protected static final State EncFinal = new State(4);
    protected static final State DecInit = new State(5);
    protected static final State DecAad = new State(6);
    protected static final State DecData = new State(7);
    protected static final State DecFinal = new State(8);
    protected State m_state = Uninitialized;
    protected String algorithmName;
    protected byte[] mac;
    protected byte[] initialAssociatedText;
    protected int CRYPTO_KEYBYTES;
    protected int CRYPTO_ABYTES;
    protected int nr;
    protected int ASCON_AEAD_RATE;
    protected long K0;
    protected long K1;
    protected long N0;
    protected long N1;
    protected long ASCON_IV;
    protected long x0;
    protected long x1;
    protected long x2;
    protected long x3;
    protected long x4;
    protected int m_bufferSizeDecrypt;
    protected byte[] m_buf;
    protected int m_bufPos = 0;
    protected long dsep;

    AsconBaseEngine() {
    }

    protected abstract long pad(int var1);

    protected abstract long loadBytes(byte[] var1, int var2);

    protected abstract void setBytes(long var1, byte[] var3, int var4);

    private void round(long l) {
        long l2 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ l ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ l);
        long l3 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ l ^ (this.x1 ^ this.x2 ^ l) & (this.x1 ^ this.x3);
        long l4 = this.x1 ^ this.x2 ^ this.x4 ^ l ^ this.x3 & this.x4;
        long l5 = this.x0 ^ this.x1 ^ this.x2 ^ l ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
        long l6 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
        this.x0 = l2 ^ Longs.rotateRight(l2, 19) ^ Longs.rotateRight(l2, 28);
        this.x1 = l3 ^ Longs.rotateRight(l3, 39) ^ Longs.rotateRight(l3, 61);
        this.x2 = l4 ^ Longs.rotateRight(l4, 1) ^ Longs.rotateRight(l4, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.x3 = l5 ^ Longs.rotateRight(l5, 10) ^ Longs.rotateRight(l5, 17);
        this.x4 = l6 ^ Longs.rotateRight(l6, 7) ^ Longs.rotateRight(l6, 41);
    }

    protected void p(int n) {
        if (n == 12) {
            this.round(240L);
            this.round(225L);
            this.round(210L);
            this.round(195L);
        }
        if (n >= 8) {
            this.round(180L);
            this.round(165L);
        }
        this.round(150L);
        this.round(135L);
        this.round(120L);
        this.round(105L);
        this.round(90L);
        this.round(75L);
    }

    protected abstract void ascon_aeadinit();

    protected void checkAAD() {
        switch (this.m_state.ord) {
            case 5: {
                this.m_state = DecAad;
                break;
            }
            case 1: {
                this.m_state = EncAad;
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    protected boolean checkData() {
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                this.finishAAD(DecData);
                return false;
            }
            case 1: 
            case 2: {
                this.finishAAD(EncData);
                return true;
            }
            case 7: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
    }

    private void finishAAD(State state) {
        switch (this.m_state.ord) {
            case 2: 
            case 6: {
                this.processFinalAadBlock();
                this.p(this.nr);
                break;
            }
        }
        this.x4 ^= this.dsep;
        this.m_bufPos = 0;
        this.m_state = state;
    }

    protected abstract void processFinalAadBlock();

    protected abstract void processFinalDecrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void processFinalEncrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected void processBufferAAD(byte[] byArray, int n) {
        this.x0 ^= this.loadBytes(byArray, n);
        if (this.ASCON_AEAD_RATE == 16) {
            this.x1 ^= this.loadBytes(byArray, 8 + n);
        }
        this.p(this.nr);
    }

    protected void processBufferDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n2 + this.ASCON_AEAD_RATE > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        long l = this.loadBytes(byArray, n);
        this.setBytes(this.x0 ^ l, byArray2, n2);
        this.x0 = l;
        if (this.ASCON_AEAD_RATE == 16) {
            long l2 = this.loadBytes(byArray, n + 8);
            this.setBytes(this.x1 ^ l2, byArray2, n2 + 8);
            this.x1 = l2;
        }
        this.p(this.nr);
    }

    protected void processBufferEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n2 + this.ASCON_AEAD_RATE > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.x0 ^= this.loadBytes(byArray, n);
        this.setBytes(this.x0, byArray2, n2);
        if (this.ASCON_AEAD_RATE == 16) {
            this.x1 ^= this.loadBytes(byArray, n + 8);
            this.setBytes(this.x1, byArray2, n2 + 8);
        }
        this.p(this.nr);
    }

    public void processAADByte(byte by) {
        this.checkAAD();
        this.m_buf[this.m_bufPos] = by;
        if (++this.m_bufPos == this.ASCON_AEAD_RATE) {
            this.processBufferAAD(this.m_buf, 0);
            this.m_bufPos = 0;
        }
    }

    public void processAADBytes(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 <= 0) {
            return;
        }
        this.checkAAD();
        if (this.m_bufPos > 0) {
            int n3 = this.ASCON_AEAD_RATE - this.m_bufPos;
            if (n2 < n3) {
                System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n2);
                this.m_bufPos += n2;
                return;
            }
            System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n3);
            n += n3;
            n2 -= n3;
            this.processBufferAAD(this.m_buf, 0);
        }
        while (n2 >= this.ASCON_AEAD_RATE) {
            this.processBufferAAD(byArray, n);
            n += this.ASCON_AEAD_RATE;
            n2 -= this.ASCON_AEAD_RATE;
        }
        System.arraycopy(byArray, n, this.m_buf, 0, n2);
        this.m_bufPos = n2;
    }

    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
        return this.processBytes(new byte[]{by}, 0, 1, byArray, n);
    }

    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        boolean bl = this.checkData();
        int n4 = 0;
        if (bl) {
            if (this.m_bufPos > 0) {
                int n5 = this.ASCON_AEAD_RATE - this.m_bufPos;
                if (n2 < n5) {
                    System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n2);
                    this.m_bufPos += n2;
                    return 0;
                }
                System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n5);
                n += n5;
                n2 -= n5;
                this.processBufferEncrypt(this.m_buf, 0, byArray2, n3);
                n4 = this.ASCON_AEAD_RATE;
            }
            while (n2 >= this.ASCON_AEAD_RATE) {
                this.processBufferEncrypt(byArray, n, byArray2, n3 + n4);
                n += this.ASCON_AEAD_RATE;
                n2 -= this.ASCON_AEAD_RATE;
                n4 += this.ASCON_AEAD_RATE;
            }
        } else {
            int n6 = this.m_bufferSizeDecrypt - this.m_bufPos;
            if (n2 < n6) {
                System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n2);
                this.m_bufPos += n2;
                return 0;
            }
            while (this.m_bufPos >= this.ASCON_AEAD_RATE) {
                this.processBufferDecrypt(this.m_buf, 0, byArray2, n3 + n4);
                this.m_bufPos -= this.ASCON_AEAD_RATE;
                System.arraycopy(this.m_buf, this.ASCON_AEAD_RATE, this.m_buf, 0, this.m_bufPos);
                n4 += this.ASCON_AEAD_RATE;
                if (n2 >= (n6 += this.ASCON_AEAD_RATE)) continue;
                System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n2);
                this.m_bufPos += n2;
                return n4;
            }
            n6 = this.ASCON_AEAD_RATE - this.m_bufPos;
            System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n6);
            n += n6;
            n2 -= n6;
            this.processBufferDecrypt(this.m_buf, 0, byArray2, n3 + n4);
            n4 += this.ASCON_AEAD_RATE;
            while (n2 >= this.m_bufferSizeDecrypt) {
                this.processBufferDecrypt(byArray, n, byArray2, n3 + n4);
                n += this.ASCON_AEAD_RATE;
                n2 -= this.ASCON_AEAD_RATE;
                n4 += this.ASCON_AEAD_RATE;
            }
        }
        System.arraycopy(byArray, n, this.m_buf, 0, n2);
        this.m_bufPos = n2;
        return n4;
    }

    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException, DataLengthException {
        int n2;
        boolean bl = this.checkData();
        if (bl) {
            n2 = this.m_bufPos + this.CRYPTO_ABYTES;
            if (n + n2 > byArray.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.processFinalEncrypt(this.m_buf, this.m_bufPos, byArray, n);
            this.mac = new byte[this.CRYPTO_ABYTES];
            this.setBytes(this.x3, this.mac, 0);
            this.setBytes(this.x4, this.mac, 8);
            System.arraycopy(this.mac, 0, byArray, n + this.m_bufPos, this.CRYPTO_ABYTES);
            this.reset(false);
        } else {
            if (this.m_bufPos < this.CRYPTO_ABYTES) {
                throw new InvalidCipherTextException("data too short");
            }
            this.m_bufPos -= this.CRYPTO_ABYTES;
            n2 = this.m_bufPos;
            if (n + n2 > byArray.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.processFinalDecrypt(this.m_buf, this.m_bufPos, byArray, n);
            this.x3 ^= this.loadBytes(this.m_buf, this.m_bufPos);
            this.x4 ^= this.loadBytes(this.m_buf, this.m_bufPos + 8);
            if ((this.x3 | this.x4) != 0L) {
                throw new InvalidCipherTextException("mac check in " + this.getAlgorithmName() + " failed");
            }
            this.reset(true);
        }
        return n2;
    }

    public byte[] getMac() {
        return this.mac;
    }

    public int getUpdateOutputSize(int n) {
        int n2 = Math.max(0, n);
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                n2 = Math.max(0, n2 - this.CRYPTO_ABYTES);
                break;
            }
            case 7: 
            case 8: {
                n2 = Math.max(0, n2 + this.m_bufPos - this.CRYPTO_ABYTES);
                break;
            }
            case 3: 
            case 4: {
                n2 += this.m_bufPos;
                break;
            }
        }
        return n2 - n2 % this.ASCON_AEAD_RATE;
    }

    public int getOutputSize(int n) {
        int n2 = Math.max(0, n);
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                return Math.max(0, n2 - this.CRYPTO_ABYTES);
            }
            case 7: 
            case 8: {
                return Math.max(0, n2 + this.m_bufPos - this.CRYPTO_ABYTES);
            }
            case 3: 
            case 4: {
                return n2 + this.m_bufPos + this.CRYPTO_ABYTES;
            }
        }
        return n2 + this.CRYPTO_ABYTES;
    }

    public void reset() {
        this.reset(true);
    }

    protected void reset(boolean bl) {
        if (bl) {
            this.mac = null;
        }
        Arrays.clear(this.m_buf);
        this.m_bufPos = 0;
        switch (this.m_state.ord) {
            case 1: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.m_state = DecInit;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.m_state = EncFinal;
                return;
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
        this.ascon_aeadinit();
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public int getKeyBytesSize() {
        return this.CRYPTO_KEYBYTES;
    }

    public int getIVBytesSize() {
        return this.CRYPTO_ABYTES;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public abstract String getAlgorithmVersion();

    protected static class State {
        int ord;

        private State(int n) {
            this.ord = n;
        }
    }
}

