/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.util.Arrays;

public class HybridValueParameterSpec
implements AlgorithmParameterSpec,
Destroyable {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final boolean doPrepend;
    private volatile byte[] t;
    private volatile AlgorithmParameterSpec baseSpec;

    public HybridValueParameterSpec(byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec) {
        this(byArray, false, algorithmParameterSpec);
    }

    public HybridValueParameterSpec(byte[] byArray, boolean bl, AlgorithmParameterSpec algorithmParameterSpec) {
        this.t = byArray;
        this.baseSpec = algorithmParameterSpec;
        this.doPrepend = bl;
    }

    public boolean isPrependedT() {
        return this.doPrepend;
    }

    public byte[] getT() {
        byte[] byArray = this.t;
        this.checkDestroyed();
        return byArray;
    }

    public AlgorithmParameterSpec getBaseParameterSpec() {
        AlgorithmParameterSpec algorithmParameterSpec = this.baseSpec;
        this.checkDestroyed();
        return algorithmParameterSpec;
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.t);
            this.t = null;
            this.baseSpec = null;
        }
    }

    private void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("spec has been destroyed");
        }
    }

    private static class AtomicBoolean {
        private volatile boolean value;

        AtomicBoolean(boolean bl) {
            this.value = bl;
        }

        public synchronized void set(boolean bl) {
            this.value = bl;
        }

        public synchronized boolean getAndSet(boolean bl) {
            boolean bl2 = this.value;
            this.value = bl;
            return bl2;
        }

        public synchronized boolean get() {
            return this.value;
        }
    }
}

