/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.util;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class ECKeyUtil {
    public static ECPublicKey createKeyWithCompression(ECPublicKey eCPublicKey) {
        return new ECPublicKeyWithCompression(eCPublicKey);
    }

    private static class ECPublicKeyWithCompression
    implements ECPublicKey {
        private final ECPublicKey ecPublicKey;

        public ECPublicKeyWithCompression(ECPublicKey eCPublicKey) {
            this.ecPublicKey = eCPublicKey;
        }

        public ECPoint getQ() {
            return this.ecPublicKey.getQ();
        }

        public String getAlgorithm() {
            return this.ecPublicKey.getAlgorithm();
        }

        public String getFormat() {
            return this.ecPublicKey.getFormat();
        }

        public byte[] getEncoded() {
            ECCurve eCCurve;
            Object object;
            Object object2;
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(this.ecPublicKey.getEncoded());
            X962Parameters x962Parameters = X962Parameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            if (x962Parameters.isNamedCurve()) {
                object2 = (ASN1ObjectIdentifier)x962Parameters.getParameters();
                object = CustomNamedCurves.getByOIDLazy((ASN1ObjectIdentifier)object2);
                if (object == null) {
                    object = ECNamedCurveTable.getByOIDLazy((ASN1ObjectIdentifier)object2);
                }
                eCCurve = ((X9ECParametersHolder)object).getCurve();
            } else {
                if (x962Parameters.isImplicitlyCA()) {
                    throw new IllegalStateException("unable to identify implictlyCA");
                }
                object2 = X9ECParameters.getInstance(x962Parameters.getParameters());
                eCCurve = ((X9ECParameters)object2).getCurve();
            }
            object2 = eCCurve.decodePoint(subjectPublicKeyInfo.getPublicKeyData().getOctets());
            object = ASN1OctetString.getInstance(new X9ECPoint((ECPoint)object2, true).toASN1Primitive());
            try {
                return new SubjectPublicKeyInfo(subjectPublicKeyInfo.getAlgorithm(), ((ASN1OctetString)object).getOctets()).getEncoded();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("unable to encode EC public key: " + iOException.getMessage());
            }
        }

        public ECParameterSpec getParameters() {
            return this.ecPublicKey.getParameters();
        }

        public ECParameterSpec getParams() {
            return this.ecPublicKey.getParams();
        }
    }
}

