/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse;

import java.net.Socket;
import java.security.Principal;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509Key;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BCX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    public BCX509Key chooseClientKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        if (null != keyTypes) {
            for (String keyType : keyTypes) {
                BCX509Key key;
                String alias = this.chooseClientAlias(new String[]{keyType}, issuers, socket);
                if (null == alias || null == (key = this.validateKeyBC(false, keyType, alias, socket))) continue;
                return key;
            }
        }
        return null;
    }

    public BCX509Key chooseEngineClientKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        if (null != keyTypes) {
            for (String keyType : keyTypes) {
                BCX509Key key;
                String alias = this.chooseEngineClientAlias(new String[]{keyType}, issuers, engine);
                if (null == alias || null == (key = this.validateKeyBC(false, keyType, alias, engine))) continue;
                return key;
            }
        }
        return null;
    }

    public BCX509Key chooseEngineServerKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        if (null != keyTypes) {
            for (String keyType : keyTypes) {
                BCX509Key key;
                String alias = this.chooseEngineServerAlias(keyType, issuers, engine);
                if (null == alias || null == (key = this.validateKeyBC(true, keyType, alias, engine))) continue;
                return key;
            }
        }
        return null;
    }

    public BCX509Key chooseServerKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        if (null != keyTypes) {
            for (String keyType : keyTypes) {
                BCX509Key key;
                String alias = this.chooseServerAlias(keyType, issuers, socket);
                if (null == alias || null == (key = this.validateKeyBC(true, keyType, alias, socket))) continue;
                return key;
            }
        }
        return null;
    }

    protected abstract BCX509Key getKeyBC(String var1, String var2);

    protected BCX509Key validateKeyBC(boolean forServer, String keyType, String alias, Socket socket) {
        return this.getKeyBC(keyType, alias);
    }

    protected BCX509Key validateKeyBC(boolean forServer, String keyType, String alias, SSLEngine engine) {
        return this.getKeyBC(keyType, alias);
    }
}

