/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class JcaAlgorithmDecomposer
implements AlgorithmDecomposer {
    private static final Pattern PATTERN = Pattern.compile("with|and|(?<!padd)in", 2);
    static final JcaAlgorithmDecomposer INSTANCE_JCA = new JcaAlgorithmDecomposer();

    JcaAlgorithmDecomposer() {
    }

    @Override
    public Set<String> decompose(String algorithm) {
        if (algorithm.indexOf(47) < 0) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String section : algorithm.split("/")) {
            if (section.length() <= 0) continue;
            for (String part : PATTERN.split(section)) {
                if (part.length() <= 0) continue;
                result.add(part);
            }
        }
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA1", "SHA-1");
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA224", "SHA-224");
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA256", "SHA-256");
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA384", "SHA-384");
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA512", "SHA-512");
        return result;
    }

    private static void ensureBothIfEither(Set<String> elements, String a, String b) {
        boolean hasB;
        boolean hasA = elements.contains(a);
        if (hasA ^ (hasB = elements.contains(b))) {
            elements.add(hasA ? b : a);
        }
    }
}

