/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultTlsCredentialedSigner
implements TlsCredentialedSigner {
    protected TlsCryptoParameters cryptoParams;
    protected Certificate certificate;
    protected SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    protected TlsSigner signer;

    public DefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, TlsSigner signer, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (signer == null) {
            throw new IllegalArgumentException("'signer' cannot be null");
        }
        this.signer = signer;
        this.cryptoParams = cryptoParams;
        this.certificate = certificate;
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] generateRawSignature(byte[] hash) throws IOException {
        return this.signer.generateRawSignature(this.getEffectiveAlgorithm(), hash);
    }

    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    public TlsStreamSigner getStreamSigner() throws IOException {
        return this.signer.getStreamSigner(this.getEffectiveAlgorithm());
    }

    protected SignatureAndHashAlgorithm getEffectiveAlgorithm() {
        SignatureAndHashAlgorithm algorithm = null;
        if (TlsImplUtils.isTLSv12(this.cryptoParams) && (algorithm = this.getSignatureAndHashAlgorithm()) == null) {
            throw new IllegalStateException("'signatureAndHashAlgorithm' cannot be null for (D)TLS 1.2+");
        }
        return algorithm;
    }
}

